/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.dev.webdav.jaxrs.xml.elements.Response;
import net.java.dev.webdav.jaxrs.xml.elements.ResponseDescription;
import net.java.dev.webdav.util.Utilities;

@XmlType(propOrder={"responses", "responseDescription"})
@XmlRootElement(name="multistatus")
public final class MultiStatus {
    @XmlElement(name="response")
    private final List<Response> responses;
    @XmlElement(name="responsedescription")
    private final ResponseDescription responseDescription;

    public MultiStatus() {
        this.responses = new LinkedList<Response>();
        this.responseDescription = null;
    }

    public MultiStatus(ResponseDescription responseDescription, Response ... responses) {
        this.responses = responses == null || responses.length == 0 ? Collections.emptyList() : Arrays.asList(responses);
        this.responseDescription = responseDescription;
    }

    public MultiStatus(Response ... responses) {
        this((ResponseDescription)null, responses);
    }

    public MultiStatus(ResponseDescription responseDescription) {
        this(responseDescription, (Response[])null);
    }

    public final List<Response> getResponses() {
        return Collections.unmodifiableList(this.responses);
    }

    public final ResponseDescription getResponseDescription() {
        return this.responseDescription;
    }

    public final int hashCode() {
        return Objects.hash(this.responses, this.responseDescription);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiStatus)) {
            return false;
        }
        MultiStatus that = (MultiStatus)o;
        return Arrays.equals(Utilities.array(this.responses, this.responseDescription), Utilities.array(that.responses, that.responseDescription));
    }

    public final String toString() {
        return Utilities.toString(this, this.responses, this.responseDescription);
    }
}

