/**
 * Flexmojos is a set of maven goals to allow maven users to compile, optimize and test Flex SWF, Flex SWC, Air SWF and Air SWC.
 * Copyright (C) 2008-2012  Marvin Froeder <marvin@flexmojos.net>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.flexmojos.oss.plugin.generator;

import org.apache.maven.plugin.MojoExecutionException;
import net.flexmojos.oss.generator.SimpleGeneratorMojo;
import net.flexmojos.oss.plugin.utilities.MavenUtils;

/**
 * This goal generate actionscript 3 code based on Java classes. It does uses Granite GAS3.
 * 
 * @author Marvin Herman Froeder (velo.br@gmail.com)
 * @author edward.yakop@gmail.com
 * @goal generate
 * @phase generate-sources
 * @extendsPlugin flexmojos-generator-mojo
 * @extendsGoal generate
 * @requiresDependencyResolution test
 * @since 1.0
 */
public class GeneratorMojo
    extends SimpleGeneratorMojo
{

    public void execute()
        throws MojoExecutionException
    {
        getLog().info( "flexmojos " + MavenUtils.getFlexMojosVersion()
                           + " - GNU GPL License (NO WARRANTY) - See COPYRIGHT file" );

        super.execute();
    }

}
