/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import net.dreamlu.mica.core.tuple.KeyPair;
import net.dreamlu.mica.core.utils.Base64Util;
import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.lang.Nullable;

public class RsaUtil {
    public static final String RSA_ALGORITHM = "RSA";
    public static final String RSA_PADDING = "RSA/ECB/PKCS1Padding";

    public static KeyPair genKeyPair() {
        return RsaUtil.genKeyPair(1024);
    }

    public static KeyPair genKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA_ALGORITHM);
            keyPairGen.initialize(keySize);
            return new KeyPair(keyPairGen.generateKeyPair());
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PrivateKey generatePrivateKey(String modulus, String exponent) {
        return RsaUtil.generatePrivateKey(new BigInteger(modulus), new BigInteger(exponent));
    }

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger exponent) {
        RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(modulus, exponent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PublicKey generatePublicKey(String modulus, String exponent) {
        return RsaUtil.generatePublicKey(new BigInteger(modulus), new BigInteger(exponent));
    }

    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger exponent) {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PublicKey getPublicKey(String base64PubKey) {
        Objects.requireNonNull(base64PubKey, "base64 public key is null.");
        byte[] keyBytes = Base64Util.decodeFromString(base64PubKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String getPublicKeyToBase64(String base64PubKey) {
        PublicKey publicKey = RsaUtil.getPublicKey(base64PubKey);
        return RsaUtil.getKeyString(publicKey);
    }

    public static PrivateKey getPrivateKey(String base64PriKey) {
        Objects.requireNonNull(base64PriKey, "base64 private key is null.");
        byte[] keyBytes = Base64Util.decodeFromString(base64PriKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String getKeyString(Key key) {
        return Base64Util.encodeToString(key.getEncoded());
    }

    public static String getPrivateKeyToBase64(String base64PriKey) {
        PrivateKey privateKey = RsaUtil.getPrivateKey(base64PriKey);
        return RsaUtil.getKeyString(privateKey);
    }

    public static byte[] encrypt(String base64PublicKey, byte[] data) {
        return RsaUtil.encrypt(RsaUtil.getPublicKey(base64PublicKey), data);
    }

    public static byte[] encrypt(PublicKey publicKey, byte[] data) {
        return RsaUtil.rsa(publicKey, data, 1);
    }

    public static byte[] encryptByPrivateKey(String base64PrivateKey, byte[] data) {
        return RsaUtil.encryptByPrivateKey(RsaUtil.getPrivateKey(base64PrivateKey), data);
    }

    public static String encryptByPrivateKeyToBase64(String base64PrivateKey, byte[] data) {
        return Base64Util.encodeToString(RsaUtil.encryptByPrivateKey(base64PrivateKey, data));
    }

    public static byte[] encryptByPrivateKey(PrivateKey privateKey, byte[] data) {
        return RsaUtil.rsa(privateKey, data, 1);
    }

    @Nullable
    public static String encryptToBase64(PublicKey publicKey, @Nullable String data) {
        if (StringUtil.isBlank(data)) {
            return null;
        }
        return Base64Util.encodeToString(RsaUtil.encrypt(publicKey, data.getBytes(Charsets.UTF_8)));
    }

    @Nullable
    public static String encryptToBase64(String base64PublicKey, @Nullable String data) {
        return RsaUtil.encryptToBase64(RsaUtil.getPublicKey(base64PublicKey), data);
    }

    public static byte[] decrypt(String base64PrivateKey, byte[] data) {
        return RsaUtil.decrypt(RsaUtil.getPrivateKey(base64PrivateKey), data);
    }

    public static byte[] decryptByPublicKey(String base64publicKey, byte[] data) {
        return RsaUtil.decryptByPublicKey(RsaUtil.getPublicKey(base64publicKey), data);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] data) {
        return RsaUtil.rsa(privateKey, data, 2);
    }

    public static byte[] decryptByPublicKey(PublicKey publicKey, byte[] data) {
        return RsaUtil.rsa(publicKey, data, 2);
    }

    private static byte[] rsa(Key key, byte[] data, int mode) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_PADDING);
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] decryptByPublicKeyFromBase64(PublicKey publicKey, byte[] base64Data) {
        return RsaUtil.decryptByPublicKey(publicKey, Base64Util.decode(base64Data));
    }

    public static byte[] decryptByPublicKeyFromBase64(String base64PublicKey, byte[] base64Data) {
        return RsaUtil.decryptByPublicKeyFromBase64(RsaUtil.getPublicKey(base64PublicKey), base64Data);
    }

    @Nullable
    public static String decryptFromBase64(PrivateKey privateKey, @Nullable String base64Data) {
        if (StringUtil.isBlank(base64Data)) {
            return null;
        }
        return new String(RsaUtil.decrypt(privateKey, Base64Util.decodeFromString(base64Data)), Charsets.UTF_8);
    }

    @Nullable
    public static String decryptFromBase64(String base64PrivateKey, @Nullable String base64Data) {
        return RsaUtil.decryptFromBase64(RsaUtil.getPrivateKey(base64PrivateKey), base64Data);
    }

    public static byte[] decryptFromBase64(String base64PrivateKey, byte[] base64Data) {
        return RsaUtil.decrypt(base64PrivateKey, Base64Util.decode(base64Data));
    }

    @Nullable
    public static String decryptByPublicKeyFromBase64(PublicKey publicKey, @Nullable String base64Data) {
        if (StringUtil.isBlank(base64Data)) {
            return null;
        }
        return new String(RsaUtil.decryptByPublicKey(publicKey, Base64Util.decodeFromString(base64Data)), Charsets.UTF_8);
    }

    @Nullable
    public static String decryptByPublicKeyFromBase64(String base64PublicKey, @Nullable String base64Data) {
        return RsaUtil.decryptByPublicKeyFromBase64(RsaUtil.getPublicKey(base64PublicKey), base64Data);
    }
}

