/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.je;

import com.google.common.base.Preconditions;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import net.derquinse.bocas.Bocas;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.je.DefaultJEBocas;
import net.derquinse.common.base.NotInstantiable;

public final class JEBocas
extends NotInstantiable {
    private JEBocas() {
    }

    public static Bocas basic(String directory) {
        Preconditions.checkNotNull((Object)directory, (Object)"The environment directory must be provided");
        File d = new File(directory);
        Preconditions.checkArgument((boolean)d.exists(), (Object)"The directory [%] does not exist");
        Preconditions.checkArgument((boolean)d.isDirectory(), (Object)"The provided file [%] is not a directory");
        EnvironmentConfig ec = new EnvironmentConfig();
        ec.setAllowCreate(true);
        ec.setReadOnly(false);
        ec.setTransactional(true);
        try {
            Environment e = new Environment(d, ec);
            return new DefaultJEBocas(e);
        }
        catch (DatabaseException e) {
            throw new BocasException((Throwable)e);
        }
    }
}

