/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.bocas.je;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import net.derquinse.bocas.BocasException;
import net.derquinse.bocas.BocasValue;
import net.derquinse.bocas.LoadedBocasEntry;
import net.derquinse.bocas.LoadedBocasValue;
import net.derquinse.bocas.SkeletalBocasBackend;
import net.derquinse.common.base.ByteString;

@Beta
final class DefaultJEBocas
extends SkeletalBocasBackend {
    private static final String DB_NAME = "BocasDB";
    private final Environment environment;
    private final Database database;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private boolean open = true;

    private static void checkKey(ByteString key) {
        Preconditions.checkNotNull((Object)key, (Object)"The object key must be provided");
    }

    private static void checkKeys(Iterable<ByteString> key) {
        Preconditions.checkNotNull(key, (Object)"The object keys must be provided");
    }

    DefaultJEBocas(Environment e) {
        this.environment = (Environment)Preconditions.checkNotNull((Object)e, (Object)"The environment must be provided");
        DatabaseConfig dc = new DatabaseConfig();
        dc.setAllowCreate(true);
        dc.setTransactional(true);
        dc.setReadOnly(false);
        this.database = e.openDatabase(null, DB_NAME, dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void close() {
        this.lock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            try {
                this.database.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.environment.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void ensureOpen() {
        Preconditions.checkState((boolean)this.open, (Object)"Database already closed");
    }

    public boolean contains(final ByteString key) {
        DefaultJEBocas.checkKey(key);
        return (Boolean)new Tx<Boolean>(){

            @Override
            Boolean perform() throws IOException {
                return this.read(key).isPresent();
            }
        }.run();
    }

    public Set<ByteString> contained(final Iterable<ByteString> keys) {
        DefaultJEBocas.checkKeys(keys);
        return (Set)new Tx<Set<ByteString>>(){

            @Override
            Set<ByteString> perform() throws IOException {
                HashSet set = Sets.newHashSet();
                for (ByteString key : keys) {
                    DefaultJEBocas.checkKey(key);
                    if (set.contains(key) || !this.read(key).isPresent()) continue;
                    set.add(key);
                }
                return set;
            }
        }.run();
    }

    public Optional<BocasValue> get(final ByteString key) {
        DefaultJEBocas.checkKey(key);
        return (Optional)new Tx<Optional<BocasValue>>(){

            @Override
            Optional<BocasValue> perform() throws IOException {
                return this.read(key);
            }
        }.run();
    }

    public Map<ByteString, BocasValue> get(final Iterable<ByteString> keys) {
        DefaultJEBocas.checkKeys(keys);
        return (Map)new Tx<Map<ByteString, BocasValue>>(){

            @Override
            Map<ByteString, BocasValue> perform() throws IOException {
                HashMap map = Maps.newHashMap();
                for (ByteString key : keys) {
                    Optional<BocasValue> v;
                    DefaultJEBocas.checkKey(key);
                    if (map.containsKey(key) || !(v = this.read(key)).isPresent()) continue;
                    map.put(key, v.get());
                }
                return map;
            }
        }.run();
    }

    protected void put(final LoadedBocasEntry entry) {
        new Put(){

            @Override
            void put() {
                this.write(entry);
            }
        }.run();
    }

    protected void put(final Map<ByteString, LoadedBocasValue> entries) {
        new Put(){

            @Override
            void put() {
                for (Map.Entry entry : entries.entrySet()) {
                    this.write((ByteString)entry.getKey(), (LoadedBocasValue)entry.getValue());
                }
            }
        }.run();
    }

    private abstract class Put
    extends Tx<Object> {
        private Put() {
        }

        @Override
        final ByteString perform() throws IOException {
            this.put();
            return null;
        }

        abstract void put();
    }

    private abstract class Tx<T> {
        private Transaction tx;

        private Tx() {
        }

        final T run() {
            DefaultJEBocas.this.lock.readLock().lock();
            try {
                DefaultJEBocas.this.ensureOpen();
                T t = this.runTx();
                return t;
            }
            catch (DatabaseException e) {
                throw new BocasException((Throwable)e);
            }
            catch (IOException e) {
                throw new BocasException((Throwable)e);
            }
            finally {
                DefaultJEBocas.this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T runTx() throws IOException {
            boolean ok = false;
            this.tx = DefaultJEBocas.this.environment.beginTransaction(null, null);
            try {
                T value = this.perform();
                ok = true;
                T t = value;
                return t;
            }
            finally {
                if (ok) {
                    this.tx.commit();
                } else {
                    this.tx.abort();
                }
            }
        }

        private DatabaseEntry key(ByteString key) {
            return new DatabaseEntry(key.toByteArray());
        }

        final Optional<BocasValue> read(ByteString key) {
            DatabaseEntry k = this.key(key);
            DatabaseEntry v = new DatabaseEntry();
            if (DefaultJEBocas.this.database.get(this.tx, k, v, null) == OperationStatus.SUCCESS) {
                LoadedBocasValue bv = BocasValue.of((byte[])v.getData());
                return Optional.of((Object)bv);
            }
            return Optional.absent();
        }

        final void write(ByteString key, LoadedBocasValue value) {
            DatabaseEntry k = this.key(key);
            DatabaseEntry v = new DatabaseEntry(value.getData());
            DefaultJEBocas.this.database.putNoOverwrite(this.tx, k, v);
        }

        final void write(LoadedBocasEntry entry) {
            this.write(entry.getKey(), entry.getValue());
        }

        abstract T perform() throws IOException;
    }
}

