/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.Option;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PluginUsageBuilder {
    protected static final Pattern TITLE_PATTERN = Pattern.compile("doc\\.(\\d)\\.title\\.(\\w+)");
    protected final ResourceBundle baseResourceBundle;
    protected final ResourceBundle resourceBundle;
    protected final String keyBase;
    protected boolean firstOption = true;

    protected PluginUsageBuilder(ResourceBundle baseResourceBundle, ResourceBundle resourceBundle) {
        this.baseResourceBundle = baseResourceBundle;
        this.resourceBundle = resourceBundle;
        this.keyBase = "usage";
    }

    public abstract PluginUsageBuilder addMain(String var1);

    public abstract <T> PluginUsageBuilder addOption(Option<?> var1);

    protected static String transformName(String xmlName) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String word : xmlName.split("\\-")) {
            if (first) {
                sb.append(word);
                first = false;
                continue;
            }
            sb.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return sb.toString();
    }

    protected SortedSet<Section> getSections() {
        TreeSet<Section> sections = new TreeSet<Section>();
        for (String titleKey : this.baseResourceBundle.keySet()) {
            Matcher matcher = TITLE_PATTERN.matcher(titleKey);
            if (!matcher.matches()) continue;
            int index = Integer.parseInt(matcher.group(1));
            String sectionName = matcher.group(2);
            String title = this.baseResourceBundle.getString(titleKey);
            String bodyKey = "doc." + sectionName;
            if (title.isEmpty() || !this.resourceBundle.containsKey(bodyKey)) continue;
            sections.add(new Section(index, title, this.resourceBundle.getString(bodyKey)));
        }
        return sections;
    }

    protected class Section
    implements Comparable<Section> {
        protected final int index;
        protected final String title;
        protected final String body;

        public Section(int index, String title, String body) {
            this.index = index;
            this.title = title;
            this.body = body;
        }

        @Override
        public int compareTo(Section o) {
            return this.index > o.index ? 1 : (this.index == o.index ? 0 : -1);
        }
    }
}

