/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.user;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.NameType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Names
extends MockUnitBase
implements MockUnitString {
    public static Names names() {
        return MockNeat.threadLocal().names();
    }

    protected Names() {
    }

    public Names(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return this.full().supplier();
    }

    public MockUnitString first() {
        return this.type(NameType.FIRST_NAME);
    }

    public MockUnitString firstAndMale() {
        return this.type(NameType.FIRST_NAME_MALE);
    }

    public MockUnitString firstAndFemale() {
        return this.type(NameType.FIRST_NAME_FEMALE);
    }

    public MockUnitString last() {
        return this.type(NameType.LAST_NAME);
    }

    public MockUnitString full() {
        Supplier<String> supp = () -> (String)this.first().val() + " " + (String)this.last().val();
        return () -> supp;
    }

    public MockUnitString full(double middleInitialProbability) {
        ValidationUtils.betweenClosed(middleInitialProbability, 0.0, 100.0);
        Supplier<String> supp = () -> {
            boolean middleName = this.mockNeat.bools().probability(middleInitialProbability).val();
            String initial = middleName ? " " + this.mockNeat.chars().upperLetters().val() + "." : "";
            return (String)this.first().val() + initial + " " + (String)this.last().val();
        };
        return () -> supp;
    }

    public MockUnitString types(NameType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            NameType nameType = this.mockNeat.from(types).val();
            return this.type(nameType).supplier();
        };
    }

    public MockUnitString type(NameType type) {
        Validate.notNull((Object)((Object)type), (String)"type", (Object[])new Object[0]);
        DictType dictType = this.mockNeat.from(type.getDictionaries()).val();
        return () -> this.mockNeat.dicts().type(dictType)::val;
    }
}

