/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitLong;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Longs
extends MockUnitBase
implements MockUnitLong {
    private final Random random;

    public static Longs longs() {
        return MockNeat.threadLocal().longs();
    }

    protected Longs() {
        this(MockNeat.threadLocal());
    }

    public Longs(MockNeat mockNeat) {
        super(mockNeat);
        this.random = mockNeat.getRandom();
    }

    @Override
    public Supplier<Long> supplier() {
        return this.random::nextLong;
    }

    public MockUnitLong bound(Long bound) {
        ValidationUtils.isTrue(bound >= 0L, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        Supplier<Long> supplier = () -> {
            long result;
            long b;
            while ((b = this.random.nextLong() << 1 >>> 1) - (result = b % bound) + bound - 1L < 0L) {
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnitLong upperBound(long upperBound) {
        return this.bound(upperBound);
    }

    public MockUnitLong lowerBound(long lowerBound) {
        ValidationUtils.notNull(lowerBound, "lowerBound");
        ValidationUtils.isTrue(lowerBound >= 0L, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(lowerBound != Integer.MAX_VALUE, "The 'lowerBound' should be different than Long.MAX_VALUE.", new Object[0]);
        return this.rangeClosed(lowerBound, Long.MAX_VALUE);
    }

    public MockUnitLong range(Long lowerBound, Long upperBound) {
        ValidationUtils.notNull(lowerBound, "lowerBound");
        ValidationUtils.notNull(upperBound, "upperBound");
        ValidationUtils.isTrue(lowerBound >= 0L, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > 0L, "The input parameter 'upperBound' should be > 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > lowerBound, "The input parameter 'upperBound' > 'lowerBound'.", new Object[0]);
        Supplier<Long> supplier = () -> (Long)this.mockNeat.longs().bound(upperBound - lowerBound).val() + lowerBound;
        return () -> supplier;
    }

    public MockUnitLong rangeClosed(long lowerBound, long upperBound) {
        ValidationUtils.notNull(lowerBound, "lowerBound");
        ValidationUtils.notNull(upperBound, "upperBound");
        ValidationUtils.isTrue(lowerBound >= 0L, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > 0L, "The input parameter 'upperBound' should be > 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > lowerBound, "The input parameter 'upperBound' > 'lowerBound'.", new Object[0]);
        Supplier<Long> supp = () -> (Long)this.mockNeat.longs().bound(upperBound - lowerBound + 1L).val() + lowerBound;
        return () -> supp;
    }

    public MockUnitLong from(long[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "alphabet", new Object[0]);
        Supplier<Long> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }
}

