/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitDouble;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Doubles
extends MockUnitBase
implements MockUnitDouble {
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private final Random random;

    public static Doubles doubles() {
        return MockNeat.threadLocal().doubles();
    }

    protected Doubles() {
        this(MockNeat.threadLocal());
    }

    public Doubles(MockNeat mockNeat) {
        super(mockNeat);
        this.random = mockNeat.getRandom();
    }

    @Override
    public Supplier<Double> supplier() {
        return this.random::nextDouble;
    }

    public MockUnitDouble gaussians() {
        return () -> this.random::nextGaussian;
    }

    public MockUnitDouble range(double lowerBound, double upperBound) {
        ValidationUtils.notNull(lowerBound, "lowerBound");
        ValidationUtils.notNull(upperBound, "upperBound");
        ValidationUtils.isFinite(lowerBound);
        ValidationUtils.isFinite(upperBound);
        ValidationUtils.isTrue(lowerBound >= 0.0, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > 0.0, "The input parameter 'upperBound' should be > 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > lowerBound, "The input parameter 'upperBound' > 'lowerBound'.", new Object[0]);
        Supplier<Double> supp = () -> {
            double result = (double)(this.random.nextLong() >>> 11) * (double)1.110223E-16f;
            if (lowerBound < upperBound && (result = result * (upperBound - lowerBound) + lowerBound) >= upperBound) {
                result = Double.longBitsToDouble(Double.doubleToLongBits(upperBound) - 1L);
            }
            return result;
        };
        return () -> supp;
    }

    public MockUnitDouble bound(double bound) {
        return this.range(0.0, bound);
    }

    public MockUnitDouble from(double[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "alphabet", new Object[0]);
        Supplier<Double> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }
}

