/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.types.enums.CharsType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Chars
extends MockUnitBase
implements MockUnit<Character> {
    public static Chars chars() {
        return MockNeat.threadLocal().chars();
    }

    protected Chars() {
    }

    public Chars(MockNeat mock) {
        super(mock);
    }

    @Override
    public Supplier<Character> supplier() {
        return this.mockNeat.from(Alphabets.ALPHA_NUMERIC)::val;
    }

    public MockUnit<Character> digits() {
        return this.mockNeat.from(Alphabets.DIGITS);
    }

    public MockUnit<Character> lowerLetters() {
        return this.mockNeat.from(Alphabets.LETTERS_LOWERCASE);
    }

    public MockUnit<Character> upperLetters() {
        return this.mockNeat.from(Alphabets.LETTERS_UPPERCASE);
    }

    public MockUnit<Character> letters() {
        return this.mockNeat.from(Alphabets.LETTERS);
    }

    public MockUnit<Character> hex() {
        return this.mockNeat.from(Alphabets.HEXA);
    }

    public MockUnit<Character> alphaNumeric() {
        return this.mockNeat.from(Alphabets.ALPHA_NUMERIC);
    }

    public MockUnit<Character> type(CharsType type) {
        ValidationUtils.notNull(type, "type");
        switch (type) {
            case DIGITS: {
                return this.digits();
            }
            case HEX: {
                return this.hex();
            }
            case LOWER_LETTERS: {
                return this.lowerLetters();
            }
            case UPPER_LETTERS: {
                return this.upperLetters();
            }
            case LETTERS: {
                return this.letters();
            }
            case ALPHA_NUMERIC: {
                return this.alphaNumeric();
            }
        }
        throw new IllegalArgumentException("Invalid CharsType");
    }

    public MockUnit<Character> types(CharsType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        Supplier<Character> supplier = () -> {
            CharsType type = this.mockNeat.from(types).val();
            return this.type(type).get();
        };
        return () -> supplier;
    }

    public MockUnit<Character> from(String alphabet) {
        ValidationUtils.notEmpty(alphabet, "alphabet");
        Supplier<Character> supp = () -> {
            int idx = this.mockNeat.getRandom().nextInt(alphabet.length());
            return Character.valueOf(alphabet.charAt(idx));
        };
        return () -> supp;
    }

    public MockUnit<Character> from(char[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "alphabet", new Object[0]);
        Supplier<Character> supp = () -> {
            int idx = this.mockNeat.getRandom().nextInt(alphabet.length);
            return Character.valueOf(alphabet[idx]);
        };
        return () -> supp;
    }
}

