/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockConstValue;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.abstraction.MockUnitValue;
import net.andreinc.mockneat.abstraction.MockValue;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.text.StringEscapeUtils;

public class CSVs
extends MockUnitBase
implements MockUnitString {
    private String separator = ",";
    private final List<MockValue<?>> columns = new LinkedList();

    public static CSVs csvs() {
        return MockNeat.threadLocal().csvs();
    }

    protected CSVs() {
    }

    public CSVs(MockNeat mockNeat) {
        super(mockNeat);
    }

    public CSVs separator(String separator) {
        ValidationUtils.notEmpty(separator, "separator");
        this.separator = separator;
        return this;
    }

    public CSVs column(MockUnit<?> mockUnit) {
        ValidationUtils.notNull(mockUnit, "mockUnit");
        this.columns.add(MockUnitValue.unit(mockUnit));
        return this;
    }

    public CSVs column(Object value) {
        ValidationUtils.notNull(value, "value");
        this.columns.add(MockConstValue.constant(value));
        return this;
    }

    @Override
    public Supplier<String> supplier() {
        ValidationUtils.isTrue(!this.columns.isEmpty(), "Cannot generate CSV without any columns.", new Object[0]);
        return () -> {
            StringBuilder buff = new StringBuilder();
            this.columns.forEach(v -> {
                buff.append(StringEscapeUtils.escapeCsv((String)v.getStr()));
                buff.append(this.separator);
            });
            buff.delete(buff.length() - this.separator.length(), buff.length());
            return buff.toString();
        };
    }

    public void write(String filePath, int numberOfLines) {
        this.write(filePath, numberOfLines, false);
    }

    public void write(Path path, int numberOfLines) {
        this.write(path, numberOfLines, false);
    }

    public void write(String filePath, int numberOfLines, boolean append) {
        ValidationUtils.notEmpty(filePath, "filePath");
        Path path = Paths.get(filePath, new String[0]);
        this.write(path, numberOfLines, append);
    }

    public void write(Path path, int numberOfLines, boolean append) {
        ValidationUtils.notNull(path, "path");
        ValidationUtils.isTrue(numberOfLines > 0, "The number of lines needs to be a positive number.", new Object[0]);
        try {
            OpenOption[] openOptionArray;
            if (append) {
                StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[3];
                standardOpenOptionArray[0] = StandardOpenOption.CREATE;
                standardOpenOptionArray[1] = StandardOpenOption.WRITE;
                openOptionArray = standardOpenOptionArray;
                standardOpenOptionArray[2] = StandardOpenOption.APPEND;
            } else {
                OpenOption[] openOptionArray2 = new StandardOpenOption[2];
                openOptionArray2[0] = StandardOpenOption.CREATE;
                openOptionArray = openOptionArray2;
                openOptionArray2[1] = StandardOpenOption.WRITE;
            }
            OpenOption[] ops = openOptionArray;
            Files.write(path, (Iterable<? extends CharSequence>)this.list(numberOfLines).val(), ops);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void append(String filePath, int numberOfLines) {
        this.write(filePath, numberOfLines, true);
    }

    public void append(Path path, int numberOfLines) {
        this.write(path, numberOfLines, true);
    }
}

