/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitDouble;
import net.andreinc.mockneat.abstraction.MockUnitInt;
import net.andreinc.mockneat.abstraction.MockUnitLong;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Froms
extends MockUnitBase {
    public Froms(MockNeat mockNeat) {
        super(mockNeat);
    }

    protected Random getRandom() {
        return this.mockNeat.getRandom();
    }

    public <T> MockUnit<T> from(List<T> alphabet) {
        Validate.notEmpty(alphabet, (String)"alphabet", (Object[])new Object[0]);
        Supplier<Object> supp = () -> {
            int idx = this.getRandom().nextInt(alphabet.size());
            return alphabet.get(idx);
        };
        return () -> supp;
    }

    public <T> MockUnit<T> from(T[] alphabet) {
        Validate.notEmpty((Object[])alphabet, (String)"alphabet", (Object[])new Object[0]);
        Supplier<Object> supp = () -> {
            int idx = this.getRandom().nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }

    public <T extends Enum<?>> MockUnit<T> from(Class<T> enumClass) {
        ValidationUtils.notNull(enumClass, "enumClass");
        Enum[] arr = (Enum[])enumClass.getEnumConstants();
        return this.from(arr);
    }

    public <T> MockUnit<T> fromKeys(Map<T, ?> map) {
        Validate.notEmpty(map, (String)"Input parameter: '#{input}' should not be empty or NULL.", (Object[])new Object[]{"map"});
        Supplier<Object> supp = () -> {
            Object[] keys = map.keySet().toArray();
            int idx = this.getRandom().nextInt(keys.length);
            return keys[idx];
        };
        return () -> supp;
    }

    public <T> MockUnit<T> fromValues(Map<?, T> map) {
        Validate.notEmpty(map, (String)"Input parameter: '#{input}' should not be empty or NULL.", (Object[])new Object[]{"map"});
        Supplier<Object> supp = () -> {
            Object[] values = map.values().toArray();
            int idx = this.getRandom().nextInt(values.length);
            return values[idx];
        };
        return () -> supp;
    }

    public MockUnitInt fromInts(Integer[] alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitInt fromInts(int[] alphabet) {
        return () -> this.mockNeat.ints().from(alphabet)::val;
    }

    public MockUnitInt fromInts(List<Integer> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitInt fromIntsValues(Map<?, Integer> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitInt fromIntsKeys(Map<Integer, ?> map) {
        return () -> this.fromKeys(map)::val;
    }

    public MockUnitDouble fromDoubles(Double[] alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitDouble fromDoubles(double[] alphabet) {
        return () -> this.mockNeat.doubles().from(alphabet)::val;
    }

    public MockUnitDouble fromDoubles(List<Double> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitDouble fromDoublesValues(Map<?, Double> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitDouble fromDoublesKeys(Map<Double, ?> map) {
        return () -> this.fromKeys(map)::val;
    }

    public MockUnitLong fromLongs(Long[] alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitLong fromLongs(long[] alphabet) {
        return () -> this.mockNeat.longs().from(alphabet)::val;
    }

    public MockUnitLong fromLongs(List<Long> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitLong fromLongsValues(Map<?, Long> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitLong fromLongsKeys(Map<Long, ?> map) {
        return () -> this.fromKeys(map)::val;
    }

    public MockUnitString fromStrings(String[] alphabet) {
        return () -> () -> this.from(alphabet).val();
    }

    public MockUnitString fromStrings(List<String> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitString fromStringsValues(Map<?, String> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitString fromStringsKeys(Map<String, ?> map) {
        return () -> this.fromKeys(map)::val;
    }
}

