/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.abstraction;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.utils.ValidationUtils;

public interface MockUnitLong
extends MockUnit<Long> {
    default public MockUnit<LongStream> longStream() {
        Supplier<LongStream> supp = () -> LongStream.generate(((Supplier)this.supplier())::get);
        return () -> supp;
    }

    default public MockUnit<long[]> arrayPrimitive(int size) {
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<long[]> supp = () -> {
            long[] array = new long[size];
            IntStream.range(0, size).forEach(i -> {
                array[i] = (Long)this.val();
            });
            return array;
        };
        return () -> supp;
    }

    default public MockUnit<Long[]> array(int size) {
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Long[]> supp = () -> {
            Long[] result = new Long[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Long)this.val();
            });
            return result;
        };
        return () -> supp;
    }
}

