/*
 * Decompiled with CFR 0.152.
 */
package name.falgout.jeffrey.testing.junit5;

import com.google.common.collect.Iterables;
import java.lang.reflect.Parameter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import name.falgout.jeffrey.testing.junit5.CaptorParameterFactory;
import name.falgout.jeffrey.testing.junit5.MockParameterFactory;
import name.falgout.jeffrey.testing.junit5.ParameterFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public final class MockitoExtension
implements TestInstancePostProcessor,
AfterEachCallback,
ParameterResolver {
    private final Set<ParameterFactory> parameterFactories = new LinkedHashSet<ParameterFactory>();

    public MockitoExtension() {
        this.parameterFactories.add(new MockParameterFactory());
        this.parameterFactories.add(new CaptorParameterFactory());
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        MockitoAnnotations.initMocks((Object)testInstance);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Mockito.validateMockitoUsage();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.getSupportedFactories(parameterContext.getParameter()).findAny().isPresent();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        List validFactories = this.getSupportedFactories(parameterContext.getParameter()).collect(Collectors.toList());
        if (validFactories.size() > 1) {
            throw new ParameterResolutionException(String.format("Too many factories: %s for parameter: %s", validFactories, parameterContext.getParameter()));
        }
        return ((ParameterFactory)Iterables.getOnlyElement(validFactories)).getParameterValue(parameterContext.getParameter());
    }

    private Stream<ParameterFactory> getSupportedFactories(Parameter parameter) {
        return this.parameterFactories.stream().filter(factory -> factory.supports(parameter));
    }
}

