/*
 * Decompiled with CFR 0.152.
 */
package name.falgout.jeffrey.testing.junit5;

import java.lang.reflect.Parameter;
import name.falgout.jeffrey.testing.junit5.ParameterFactory;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

final class MockParameterFactory
implements ParameterFactory {
    MockParameterFactory() {
    }

    @Override
    public boolean supports(Parameter parameter) {
        return parameter.isAnnotationPresent(Mock.class);
    }

    @Override
    public Object getParameterValue(Parameter parameter) {
        Mock annotation = parameter.getAnnotation(Mock.class);
        MockSettings settings = Mockito.withSettings();
        if (annotation.extraInterfaces().length > 0) {
            settings.extraInterfaces(annotation.extraInterfaces());
        }
        if (annotation.serializable()) {
            settings.serializable();
        }
        settings.name(annotation.name().isEmpty() ? parameter.getName() : annotation.name());
        settings.defaultAnswer((Answer)annotation.answer());
        return Mockito.mock(parameter.getType(), (MockSettings)settings);
    }
}

