/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnectionFactory;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyXAConnection;
import org.jboss.mq.referenceable.ObjectRefAddr;

public class SpyXAConnectionFactory
extends SpyConnectionFactory
implements Serializable,
XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory {
    static final long serialVersionUID = -3869656253676593051L;

    public SpyXAConnectionFactory(GenericConnectionFactory factory) {
        super(factory);
    }

    public SpyXAConnectionFactory(Properties config) {
        super(config);
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            return new SpyXAConnection(this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Failed to create XAConnection", e);
        }
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        try {
            if (userName == null) {
                throw new SpyJMSException("Username is null");
            }
            if (password == null) {
                throw new SpyJMSException("Password is null");
            }
            return new SpyXAConnection(userName, password, this.factory);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Failed to create XAConnection", e);
        }
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createXAConnection();
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        return (XAQueueConnection)this.createXAConnection(userName, password);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createXAConnection();
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        return (XATopicConnection)this.createXAConnection(userName, password);
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.mq.SpyXAConnectionFactory", new ObjectRefAddr("DCF", this.factory), "org.jboss.mq.referenceable.SpyConnectionFactoryObjectFactory", null);
    }
}

