/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.remoting;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.remoting.IsLocalInterceptor;
import org.jboss.logging.Logger;

public class ClusteredIsLocalInterceptor
extends IsLocalInterceptor {
    private static final long serialVersionUID = 5765933584762500725L;
    private static final Logger log = Logger.getLogger(ClusteredIsLocalInterceptor.class);
    public static final String PARTITION_NAME = "PARTITION_NAME";

    public Object invoke(Invocation invocation) throws Throwable {
        Container localContainer = this.findLocalContainer(invocation);
        if (localContainer != null) {
            return this.invokeLocal(invocation, localContainer);
        }
        return invocation.invokeNext();
    }

    private Container findLocalContainer(Invocation invocation) {
        Container container;
        String partitionName;
        String guid;
        block10: {
            guid = (String)invocation.getMetaData("IS_LOCAL", "GUID");
            partitionName = (String)invocation.getMetaData(PARTITION_NAME, PARTITION_NAME);
            container = null;
            try {
                container = Ejb3Registry.findContainer(guid);
                if (container == null) {
                    String oid = (String)invocation.getMetaData("DISPATCHER", "OID");
                    container = Ejb3Registry.getClusterContainer(Ejb3Registry.clusterUid(oid, partitionName));
                }
            }
            catch (IllegalStateException ignored) {
                if (!log.isTraceEnabled()) break block10;
                log.trace("Cannot find local container for " + guid);
            }
        }
        if (container != null) {
            if (partitionName != null) {
                if (!partitionName.equals(((EJBContainer)container).getPartitionName())) {
                    if (log.isTraceEnabled()) {
                        log.trace("Partition (" + ((EJBContainer)container).getPartitionName() + ") for local container " + guid + " does not match invocation (" + partitionName + ")");
                    }
                    container = null;
                } else if (log.isTraceEnabled()) {
                    log.trace("Partition (" + ((EJBContainer)container).getPartitionName() + ") for local container " + guid + " matches invocation (" + partitionName + ")");
                }
            } else {
                log.warn("No PARTITION_NAME metadata associated with invocation");
                container = null;
            }
        }
        return container;
    }
}

