/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InstanceAdvisorDelegate;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class ClassInstanceAdvisor
implements InstanceAdvisor,
Serializable {
    static final long serialVersionUID = -3057976129116723527L;
    protected ArrayList insertedInterceptors = null;
    protected ArrayList appendedInterceptors = null;
    protected WeakReference instanceRef;
    protected transient WeakReference classAdvisorRef;
    public boolean hasInstanceAspects = false;
    private InterceptorChainObserver interceptorChainObserver;
    InstanceAdvisorDelegate delegate;

    public ClassInstanceAdvisor() {
        this.delegate = new InstanceAdvisorDelegate(null, this);
        this.delegate.initialize();
    }

    public ClassInstanceAdvisor(Object obj) {
        this.instanceRef = new WeakReference<Object>(obj);
        if (obj instanceof Advised) {
            Advised advised = (Advised)obj;
            Advisor advizor = advised._getAdvisor();
            this.classAdvisorRef = new WeakReference<Advisor>(advizor);
            if (advizor instanceof ClassAdvisor) {
                this.delegate = new InstanceAdvisorDelegate(advizor, this);
                this.delegate.initialize();
                this.interceptorChainObserver = ((ClassAdvisor)advizor).getInterceptorChainObserver();
            }
        }
    }

    public boolean hasInterceptors() {
        return this.appendedInterceptors != null || this.insertedInterceptors != null;
    }

    public Object getPerInstanceAspect(String def) {
        return this.delegate.getPerInstanceAspect(def);
    }

    public Object getPerInstanceAspect(AspectDefinition def) {
        return this.delegate.getPerInstanceAspect(def);
    }

    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        return this.delegate.getPerInstanceJoinpointAspect(joinpoint, def);
    }

    public SimpleMetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    public Interceptor[] getInterceptors() {
        ArrayList newlist = new ArrayList();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public Interceptor[] getInterceptors(Interceptor[] advisorChain) {
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(index, interceptor);
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void insertInterceptor(Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(interceptor);
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(interceptor);
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(index, interceptor);
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void removeInterceptor(String name) {
        int interceptorsRemoved = this.internalRemoveInterceptor(name);
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    private int internalRemoveInterceptor(String name) {
        ArrayList newList;
        Interceptor interceptor;
        int i;
        int interceptorsRemoved = 0;
        if (this.insertedInterceptors != null) {
            for (i = 0; i < this.insertedInterceptors.size(); ++i) {
                interceptor = (Interceptor)this.insertedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.insertedInterceptors);
                newList.remove(i);
                this.insertedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        if (this.appendedInterceptors != null) {
            for (i = 0; i < this.appendedInterceptors.size(); ++i) {
                interceptor = (Interceptor)this.appendedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.appendedInterceptors);
                newList.remove(i);
                this.appendedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        this.hasInstanceAspects = this.insertedInterceptors != null && this.insertedInterceptors.size() > 0 || this.appendedInterceptors != null && this.appendedInterceptors.size() > 0;
        return interceptorsRemoved;
    }

    public final boolean hasAspects() {
        return this.hasInstanceAspects;
    }

    public void insertInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.getInstance() instanceof Advised) {
            Advised advised = (Advised)this.getInstance();
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create((Advisor)classAdvisor, null);
            this.insertInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void appendInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.getInstance() instanceof Advised) {
            Advised advised = (Advised)this.getInstance();
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create((Advisor)classAdvisor, null);
            this.appendInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void removeInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.getInstance() instanceof Advised) {
            Advised advised = (Advised)this.getInstance();
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsRemoved = 0;
        Iterator it = stack.getInterceptorFactories().iterator();
        while (it.hasNext()) {
            InterceptorFactory factory = (InterceptorFactory)it.next();
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create((Advisor)classAdvisor, null);
            interceptorsRemoved += this.internalRemoveInterceptor(interceptor.getName());
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    public Domain getDomain() {
        throw new RuntimeException("getDomain() is only available when you use weaving with generated advisors");
    }

    protected void finalize() {
        block3: {
            block2: {
                ClassLoader classLoader = this.getClassAdvisor().getClazz().getClassLoader();
                if (this.interceptorChainObserver == null) break block2;
                this.getClassAdvisor().getManager();
                if (AspectManager.getRegisteredCLs().containsKey(classLoader)) break block3;
            }
            return;
        }
        this.interceptorChainObserver.allInstanceInterceptorsRemoved(this);
    }

    private Advisor getClassAdvisor() {
        if (this.classAdvisorRef != null) {
            return (Advisor)this.classAdvisorRef.get();
        }
        return null;
    }

    private Object getInstance() {
        if (this.instanceRef != null) {
            return this.instanceRef.get();
        }
        return null;
    }
}

