/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.ClientAuthType;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;

public final class TLSMessageChannel
extends ConnectionOrientedMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(TLSMessageChannel.class);
    private HandshakeCompletedListener handshakeCompletedListener;

    protected TLSMessageChannel(Socket sock, SIPTransactionStack sipStack, TLSMessageProcessor msgProcessor, String threadName) throws IOException {
        super(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TLSMessageChannel (incoming)");
            logger.logStackTrace();
        }
        this.mySock = (SSLSocket)sock;
        if (sock instanceof SSLSocket) {
            try {
                SSLSocket sslSock = (SSLSocket)sock;
                if (sipStack.getClientAuth() != ClientAuthType.Want && sipStack.getClientAuth() != ClientAuthType.Disabled) {
                    sslSock.setNeedClientAuth(true);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SSLServerSocket need client auth " + sslSock.getNeedClientAuth());
                }
                this.handshakeCompletedListener = new HandshakeCompletedListenerImpl(this);
                sslSock.addHandshakeCompletedListener(this.handshakeCompletedListener);
                sslSock.startHandshake();
            }
            catch (SSLHandshakeException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName(threadName);
        this.myPort = msgProcessor.getPort();
        this.peerPort = this.mySock.getPort();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TLSMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TLSMessageProcessor messageProcessor) throws IOException {
        super(sipStack);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("creating new TLSMessageChannel (outgoing)");
            logger.logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TLS";
        this.sipStack = sipStack;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        this.messageProcessor = messageProcessor;
    }

    public void close(boolean removeSocket) {
        block11: {
            this.isRunning = false;
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Closing socket " + this.key);
                }
                try {
                    this.mySock.close();
                }
                catch (IOException ex) {
                    if (!logger.isLoggingEnabled(32)) break block11;
                    logger.logDebug("Error closing socket " + ex);
                }
            }
        }
        if (this.myParser != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing my parser " + this.myParser);
            }
            this.myParser.close();
        }
        if (removeSocket) {
            String ioHandlerKey = this.key.substring(4);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing TLS socket " + ioHandlerKey);
            }
            this.sipStack.ioHandler.removeSocket(ioHandlerKey);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing message Channel (key = " + this.key + ")" + this);
            }
            this.cancelPingKeepAliveTimeoutTaskIfStarted();
        } else if (logger.isLoggingEnabled(32)) {
            String ioHandlerKey = this.key.substring(4);
            logger.logDebug("not removing socket key from the cached map since it has already been updated by the iohandler.sendBytes " + ioHandlerKey);
        }
    }

    public String getTransport() {
        return "TLS";
    }

    protected void sendMessage(byte[] msg, boolean retry) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + retry);
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.getMessageProcessor().getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, retry, this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + this.peerPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
            logger.logError("Error is ", any);
        }
        if (sock == null) {
            if (this.peerPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                logger.logWarning("Couldn't connect to peerAddress = " + this.peerAddress + " peerPort = " + this.peerPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPortAdvertisedInHeaders, this.peerProtocol, msg, retry, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
                logger.logWarning("retry suceeded to peerAddress = " + this.peerAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("Old socket different than new socket on channel " + this.key);
                    logger.logStackTrace();
                    logger.logWarning("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    logger.logWarning("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    logger.logWarning("New socket local ip address " + sock.getLocalSocketAddress());
                    logger.logWarning("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.close(false);
            }
            if (problem == null) {
                if (this.mySock != null && logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was no exception for the retry mechanism so creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
                this.myClientInputStream = this.mySock.getInputStream();
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.setName("TCPMessageChannelThread");
                thread.start();
            } else {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was an exception for the retry mechanism so not creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
            }
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (this.peerPortAdvertisedInHeaders <= 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            }
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
            }
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TLS", message, retry, this);
        }
        catch (IOException any) {
            problem = any;
            logger.logWarning("Failed to connect " + this.peerAddress + ":" + receiverPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on, rcv addr=" + receiverAddress + ", port=" + receiverPort);
            logger.logError("Error is ", any);
        }
        if (sock == null) {
            if (receiverPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                logger.logWarning("Couldn't connect to receiverAddress = " + receiverAddress + " receiverPort = " + receiverPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, this.peerPortAdvertisedInHeaders, "TLS", message, retry, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPortAdvertisedInHeaders, "TLS");
                logger.logWarning("retry suceeded to receiverAddress = " + receiverAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("Old socket different than new socket on channel " + this.key);
                    logger.logStackTrace();
                    logger.logWarning("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    logger.logWarning("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    logger.logWarning("New socket local ip address " + sock.getLocalSocketAddress());
                    logger.logWarning("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.close(false);
            }
            if (problem == null) {
                if (this.mySock != null && logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was no exception for the retry mechanism so creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
                this.myClientInputStream = this.mySock.getInputStream();
                Thread mythread = new Thread(this);
                mythread.setDaemon(true);
                mythread.setName("TCPMessageChannelThread");
                mythread.start();
            } else {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("There was an exception for the retry mechanism so not creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
            }
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled()) {
            logger.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            String msgString;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Encountered bad message \n" + message);
            }
            if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Sending automatic 400 Bad Request:");
                        logger.logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.getPeerInetAddress(), this.getPeerPort(), false);
                    }
                    catch (IOException e) {
                        logger.logException(e);
                    }
                } else if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TLSMessageChannel that = (TLSMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public boolean isSecure() {
        return true;
    }

    public void setHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListenerImpl) {
        this.handshakeCompletedListener = handshakeCompletedListenerImpl;
    }

    public HandshakeCompletedListenerImpl getHandshakeCompletedListener() {
        return (HandshakeCompletedListenerImpl)this.handshakeCompletedListener;
    }
}

