/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;

public class TCPMessageProcessor
extends ConnectionOrientedMessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(TCPMessageProcessor.class);

    protected TCPMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, port, "tcp", sipStack);
    }

    public void start() throws IOException {
        Thread thread = new Thread(this);
        thread.setName("TCPMessageProcessorThread");
        thread.setPriority(this.sipStack.getThreadPriority());
        thread.setDaemon(true);
        this.sock = this.sipStack.getNetworkLayer().createServerSocket(this.getPort(), 0, this.getIpAddress());
        if (this.getIpAddress().getHostAddress().equals("0.0.0.0") || this.getIpAddress().getHostAddress().equals("::0")) {
            super.setIpAddress(this.sock.getInetAddress());
        }
        this.isRunning = true;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                TCPMessageProcessor tCPMessageProcessor = this;
                synchronized (tCPMessageProcessor) {
                    while (this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                Socket newsock = this.sock.accept();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Accepting new connection!");
                }
                TCPMessageChannel newChannel = new TCPMessageChannel(newsock, this.sipStack, this, "TCPMessageChannelThread-" + this.nConnections);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug(Thread.currentThread() + " adding incoming channel " + newChannel.getKey() + " for processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
                }
                this.incomingMessageChannels.put(newChannel.getKey(), newChannel);
            }
            catch (SocketException ex) {
                this.isRunning = false;
            }
            catch (IOException ex) {
                if (!logger.isLoggingEnabled()) continue;
                logger.logException(ex);
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
    }

    public String getTransport() {
        return "tcp";
    }

    public synchronized void stop() {
        this.isRunning = false;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collection en = this.messageChannels.values();
        for (TCPMessageChannel next : en) {
            next.close();
        }
        for (TCPMessageChannel next : this.incomingMessageChannels.values()) {
            next.close();
        }
        this.notify();
    }

    public synchronized MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = MessageChannel.getKey(targetHostPort, "TCP");
        if (this.messageChannels.get(key) != null) {
            return (TCPMessageChannel)this.messageChannels.get(key);
        }
        TCPMessageChannel retval = new TCPMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.messageChannels.put(key, retval);
        retval.isCached = true;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("key " + key);
            logger.logDebug("Creating " + retval);
        }
        return retval;
    }

    public synchronized MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        try {
            String key = MessageChannel.getKey(host, port, "TCP");
            if (this.messageChannels.get(key) != null) {
                return (TCPMessageChannel)this.messageChannels.get(key);
            }
            TCPMessageChannel retval = new TCPMessageChannel(host, port, this.sipStack, this);
            this.messageChannels.put(key, retval);
            retval.isCached = true;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("key " + key);
                logger.logDebug("Creating " + retval);
            }
            return retval;
        }
        catch (UnknownHostException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }
}

