/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.ServerTransactionExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.IllegalTransactionStateException;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.EventObject;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.header.Header;
import javax.sip.message.Response;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction,
ServerTransactionExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPServerTransaction.class);
    public static final String CONTENT_TYPE_APPLICATION = "application";
    public static final String CONTENT_SUBTYPE_SDP = "sdp";
    private int rseqNumber = -1;
    private transient ServerRequestInterface requestOf;
    private SIPDialog dialog;
    protected String dialogId;
    private byte[] pendingReliableResponseAsBytes;
    private String pendingReliableResponseMethod;
    private long pendingReliableCSeqNumber;
    private long pendingReliableRSeqNumber;
    private ProvisionalResponseTask provisionalResponseTask;
    private boolean retransmissionAlertEnabled;
    private RetransmissionAlertTimerTask retransmissionAlertTimerTask;
    private ListenerExecutionMaxTimer listenerExecutionMaxTimer;
    protected boolean isAckSeen;
    private SIPClientTransaction pendingSubscribeTransaction;
    private SIPServerTransaction inviteTransaction;
    private static boolean interlockProvisionalResponses = true;
    private Semaphore provisionalResponseSem = new Semaphore(1);
    private Semaphore terminationSemaphore = new Semaphore(0);
    private byte[] lastResponseAsBytes;
    private String lastResponseHost;
    private int lastResponsePort;
    private String lastResponseTransport;
    private int lastResponseStatusCode;
    private HostPort originalRequestSentBy;
    private String originalRequestFromTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(SIPResponse transactionResponse) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sipServerTransaction::sendResponse " + transactionResponse.getFirstLine());
        }
        try {
            if (this.isReliable()) {
                this.getMessageChannel().sendMessage(transactionResponse);
            } else {
                Via via = transactionResponse.getTopmostVia();
                String transport = via.getTransport();
                if (transport == null) {
                    throw new IOException("missing transport!");
                }
                int port = via.getRPort();
                if (port == -1) {
                    port = via.getPort();
                }
                if (port == -1) {
                    port = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
                }
                String host = null;
                if (via.getMAddr() != null) {
                    host = via.getMAddr();
                } else {
                    host = via.getParameter("received");
                    if (host == null) {
                        host = via.getHost();
                    }
                }
                Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(host, port, transport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    messageChannel.sendMessage(transactionResponse);
                    this.lastResponseHost = host;
                    this.lastResponsePort = port;
                    this.lastResponseTransport = transport;
                } else {
                    throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
                }
            }
            this.lastResponseAsBytes = transactionResponse.encodeAsBytes(this.getTransport());
            this.lastResponse = null;
            Object var9_8 = null;
            this.startTransactionTimer();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.startTransactionTimer();
            throw throwable;
        }
    }

    protected SIPServerTransaction(SIPTransactionStack sipStack, MessageChannel newChannelToUse) {
        super(sipStack, newChannelToUse);
        if (sipStack.maxListenerResponseTime != -1) {
            sipStack.getTimer().schedule(new ListenerExecutionMaxTimer(), sipStack.maxListenerResponseTime * 1000);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating Server Transaction" + this.getBranchId());
            logger.logStackTrace();
        }
    }

    public void setRequestInterface(ServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        Via topViaHeader;
        boolean transactionMatches = false;
        String method = messageToTest.getCSeq().getMethod();
        SIPRequest origRequest = this.getOriginalRequest();
        if ((this.isInviteTransaction() || !this.isTerminated()) && (topViaHeader = messageToTest.getTopmostVia()) != null) {
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                transactionMatches = method.equals("CANCEL") ? this.getMethod().equals("CANCEL") && this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(origRequest.getTopmostVia().getSentBy()) : (origRequest != null ? this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(origRequest.getTopmostVia().getSentBy()) : this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(this.originalRequestSentBy));
            } else {
                origRequest = (SIPRequest)this.getRequest();
                String originalFromTag = origRequest.getFromTag();
                String thisFromTag = messageToTest.getFrom().getTag();
                boolean skipFrom = originalFromTag == null || thisFromTag == null;
                String originalToTag = origRequest.getToTag();
                String thisToTag = messageToTest.getTo().getTag();
                boolean skipTo = originalToTag == null || thisToTag == null;
                boolean isResponse = messageToTest instanceof SIPResponse;
                if (messageToTest.getCSeq().getMethod().equalsIgnoreCase("CANCEL") && !origRequest.getCSeq().getMethod().equalsIgnoreCase("CANCEL")) {
                    transactionMatches = false;
                } else if ((isResponse || origRequest.getRequestURI().equals(((SIPRequest)messageToTest).getRequestURI())) && (skipFrom || originalFromTag != null && originalFromTag.equalsIgnoreCase(thisFromTag)) && (skipTo || originalToTag != null && originalToTag.equalsIgnoreCase(thisToTag)) && origRequest.getCallId().getCallId().equalsIgnoreCase(messageToTest.getCallId().getCallId()) && origRequest.getCSeq().getSeqNumber() == messageToTest.getCSeq().getSeqNumber() && (!messageToTest.getCSeq().getMethod().equals("CANCEL") || this.getMethod().equals(messageToTest.getCSeq().getMethod())) && topViaHeader.equals(origRequest.getTopmostVia())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() {
        int realState = this.getRealState();
        if (realState < 0 || realState == 1) {
            if (this.isInviteTransaction() && !this.isMapped && this.sipStack.getTimer() != null) {
                this.isMapped = true;
                this.sipStack.getTimer().schedule(new SendTrying(), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(SIPRequest transactionRequest, MessageChannel sourceChannel) {
        block37: {
            boolean toTu = false;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("processRequest: " + transactionRequest.getFirstLine());
                logger.logDebug("tx state = " + this.getRealState());
            }
            try {
                if (this.getRealState() < 0) {
                    this.setOriginalRequest(transactionRequest);
                    this.setState(1);
                    toTu = true;
                    this.setPassToListener();
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && 3 == this.getRealState() && transactionRequest.getMethod().equals("ACK")) {
                        this.setState(4);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            this.enableTimeoutTimer(this.TIMER_I);
                        } else {
                            this.setState(5);
                        }
                        if (this.sipStack.isNon2XXAckPassedToListener()) {
                            this.requestOf.processRequest(transactionRequest, this);
                        } else {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("ACK received for server Tx " + this.getTransactionId() + " not delivering to application!");
                            }
                            this.semRelease();
                        }
                        return;
                    }
                    if (transactionRequest.getMethod().equals(this.getMethod())) {
                        if (2 == this.getRealState() || 3 == this.getRealState()) {
                            this.semRelease();
                            this.resendLastResponseAsBytes();
                        } else if (transactionRequest.getMethod().equals("ACK")) {
                            if (this.requestOf != null) {
                                this.requestOf.processRequest(transactionRequest, this);
                            } else {
                                this.semRelease();
                            }
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("completed processing retransmitted request : " + transactionRequest.getFirstLine() + this + " txState = " + this.getState() + " lastResponse = " + this.lastResponseAsBytes);
                        }
                        return;
                    }
                }
                if (3 != this.getRealState() && 5 != this.getRealState() && this.requestOf != null) {
                    if (this.getMethod().equals(transactionRequest.getMethod())) {
                        if (toTu) {
                            this.requestOf.processRequest(transactionRequest, this);
                        } else {
                            this.semRelease();
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(transactionRequest, this);
                    } else {
                        this.semRelease();
                    }
                    break block37;
                }
                if (SIPTransactionStack.isDialogCreated(this.getMethod()) && this.getRealState() == 5 && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog thisDialog = (SIPDialog)this.getDialog();
                    if (thisDialog == null || !thisDialog.ackProcessed) {
                        if (thisDialog != null) {
                            thisDialog.ackReceived(transactionRequest.getCSeq().getSeqNumber());
                            thisDialog.ackProcessed = true;
                        }
                        this.requestOf.processRequest(transactionRequest, this);
                    } else {
                        this.semRelease();
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Too late to cancel Transaction");
                    }
                    this.semRelease();
                    try {
                        this.sendMessage(transactionRequest.createResponse(200));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dropping request " + this.getRealState());
                }
            }
            catch (IOException e) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("IOException ", e);
                }
                this.semRelease();
                this.raiseIOExceptionEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        block15: {
            block14: {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sipServerTransaction::sendMessage " + messageToSend.getFirstLine());
                }
                SIPResponse transactionResponse = (SIPResponse)messageToSend;
                int statusCode = transactionResponse.getStatusCode();
                try {
                    try {
                        if (this.originalRequestBranch != null) {
                            transactionResponse.getTopmostVia().setBranch(this.getBranch());
                        } else {
                            transactionResponse.getTopmostVia().removeParameter("branch");
                        }
                        if (!this.originalRequestHasPort) {
                            transactionResponse.getTopmostVia().removePort();
                        }
                    }
                    catch (ParseException ex) {
                        logger.logError("UnexpectedException", ex);
                        throw new IOException("Unexpected exception");
                    }
                    if (!transactionResponse.getCSeq().getMethod().equals(this.getMethod())) {
                        this.sendResponse(transactionResponse);
                        Object var6_6 = null;
                        this.startTransactionTimer();
                        return;
                    }
                    if (!this.checkStateTimers(statusCode)) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("checkStateTimers returned false -- not sending message");
                        }
                        break block14;
                    }
                    try {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("sendMessage : tx = " + this + " getState = " + this.getState());
                        }
                        this.lastResponse = transactionResponse;
                        this.lastResponseStatusCode = transactionResponse.getStatusCode();
                        this.sendResponse(transactionResponse);
                        break block15;
                    }
                    catch (IOException e) {
                        this.setState(5);
                        this.collectionTime = 0;
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.startTransactionTimer();
                    throw throwable;
                }
            }
            Object var6_7 = null;
            this.startTransactionTimer();
            return;
        }
        Object var6_8 = null;
        this.startTransactionTimer();
    }

    private boolean checkStateTimers(int statusCode) {
        if (this.getRealState() == 1) {
            if (statusCode / 100 == 1) {
                this.setState(2);
            } else if (200 <= statusCode && statusCode <= 699) {
                if (!this.isInviteTransaction()) {
                    if (!this.isReliable() && this.getInternalState() != 3) {
                        this.setState(3);
                        this.startTransactionTimerJ(64L);
                        this.cleanUpOnTimer();
                    } else {
                        this.cleanUpOnTimer();
                        this.setState(5);
                        this.startTransactionTimerJ(0L);
                    }
                } else if (statusCode / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.cleanUpOnTimer();
                    this.setState(5);
                    if (this.getDialog() != null) {
                        ((SIPDialog)this.getDialog()).setRetransmissionTicks();
                    }
                } else {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.cleanUpOnTimer();
                    this.enableTimeoutTimer(64);
                }
            }
        } else if (this.getRealState() == 2) {
            if (this.isInviteTransaction()) {
                if (statusCode / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.cleanUpOnTimer();
                    this.setState(5);
                    if (this.getDialog() != null) {
                        ((SIPDialog)this.getDialog()).setRetransmissionTicks();
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(3);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.cleanUpOnTimer();
                    this.enableTimeoutTimer(64);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(3);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.startTransactionTimerJ(64L);
                } else {
                    this.setState(5);
                    this.startTransactionTimerJ(0L);
                }
                this.cleanUpOnTimer();
            }
        } else if (3 == this.getRealState()) {
            return false;
        }
        return true;
    }

    public String getViaHost() {
        return super.getViaHost();
    }

    public int getViaPort() {
        return super.getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("fireRetransmissionTimer() -- " + this + " state " + this.getState());
            }
            if (this.isInviteTransaction() && (this.lastResponse != null || this.lastResponseAsBytes != null)) {
                if (!this.retransmissionAlertEnabled || this.sipStack.isTransactionPendingAck(this)) {
                    if (this.lastResponseStatusCode / 100 >= 2 && !this.isAckSeen) {
                        this.resendLastResponseAsBytes();
                    }
                } else {
                    SipProviderImpl sipProvider = this.getSipProvider();
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)sipProvider, (ServerTransaction)this, Timeout.RETRANSMIT);
                    sipProvider.handleEvent((EventObject)txTimeout, this);
                }
            }
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logException(e);
            }
            this.raiseErrorEvent(2);
        }
    }

    public void resendLastResponseAsBytes() throws IOException {
        if (this.lastResponse != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("resend last response " + this.lastResponse);
            }
            this.sendMessage(this.lastResponse);
        } else if (this.lastResponseAsBytes != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("resend last response " + new String(this.lastResponseAsBytes));
            }
            if (this.isReliable()) {
                block15: {
                    if (logger.isLoggingEnabled(16)) {
                        try {
                            SIPResponse lastReparsedResponse = (SIPResponse)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.lastResponseAsBytes, true, false, null);
                            lastReparsedResponse.setRemoteAddress(this.getPeerInetAddress());
                            lastReparsedResponse.setRemotePort(this.getPeerPort());
                            lastReparsedResponse.setLocalPort(this.getMessageChannel().getPort());
                            lastReparsedResponse.setLocalAddress(this.getMessageChannel().getMessageProcessor().getIpAddress());
                            this.getMessageChannel().logMessage(lastReparsedResponse, this.getPeerInetAddress(), this.getPeerPort(), System.currentTimeMillis());
                        }
                        catch (ParseException e) {
                            if (!logger.isLoggingEnabled(32)) break block15;
                            logger.logDebug("couldn't reparse last response " + new String(this.lastResponseAsBytes));
                        }
                    }
                }
                this.getMessageChannel().sendMessage(this.lastResponseAsBytes, this.getPeerInetAddress(), this.getPeerPort(), false);
            } else {
                Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(this.lastResponseHost, this.lastResponsePort, this.lastResponseTransport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    block16: {
                        if (logger.isLoggingEnabled(16)) {
                            try {
                                SIPResponse lastReparsedResponse = (SIPResponse)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.lastResponseAsBytes, true, false, null);
                                lastReparsedResponse.setRemoteAddress(this.getPeerInetAddress());
                                lastReparsedResponse.setRemotePort(this.getPeerPort());
                                lastReparsedResponse.setLocalPort(this.getMessageChannel().getPort());
                                lastReparsedResponse.setLocalAddress(this.getMessageChannel().getMessageProcessor().getIpAddress());
                                this.getMessageChannel().logMessage(lastReparsedResponse, this.getPeerInetAddress(), this.getPeerPort(), System.currentTimeMillis());
                            }
                            catch (ParseException e) {
                                if (!logger.isLoggingEnabled(32)) break block16;
                                logger.logDebug("couldn't reparse last response " + new String(this.lastResponseAsBytes));
                            }
                        }
                    }
                    messageChannel.sendMessage(this.lastResponseAsBytes, InetAddress.getByName(hop.getHost()), hop.getPort(), false);
                } else {
                    throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
                }
            }
        }
    }

    private void fireReliableResponseRetransmissionTimer() {
        try {
            this.resendLastResponseAsBytes();
        }
        catch (IOException e) {
            if (logger.isLoggingEnabled()) {
                logger.logException(e);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPServerTransaction.fireTimeoutTimer this = " + this + " current state = " + this.getRealState() + " method = " + this.getMethod());
        }
        if (this.isInviteTransaction() && this.sipStack.removeTransactionPendingAck(this)) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Found tx pending ACK - returning");
            }
            return;
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (SIPTransactionStack.isDialogCreated(this.getMethod()) && (0 == this.getRealState() || 1 == this.getRealState())) {
            dialog.setState(3);
        } else if (this.getMethod().equals("BYE") && dialog != null && dialog.isTerminatedOnBye()) {
            dialog.setState(3);
        }
        if (3 == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(5);
            this.sipStack.removeTransaction(this);
        } else if (3 == this.getRealState() && !this.isInviteTransaction()) {
            this.setState(5);
            if (!this.getMethod().equals("CANCEL")) {
                this.cleanUp();
            } else {
                this.sipStack.removeTransaction(this);
            }
        } else if (4 == this.getRealState() && this.isInviteTransaction()) {
            this.setState(5);
            this.sipStack.removeTransaction(this);
        } else if (!(this.isInviteTransaction() || 3 != this.getRealState() && 4 != this.getRealState())) {
            this.setState(5);
        } else if (this.isInviteTransaction() && 5 == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(3);
            }
        }
    }

    public int getLastResponseStatusCode() {
        return this.lastResponseStatusCode;
    }

    public void setOriginalRequest(SIPRequest originalRequest) {
        super.setOriginalRequest(originalRequest);
    }

    public void sendResponse(Response response) throws SipException {
        SIPResponse sipResponse = (SIPResponse)response;
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (response == null) {
            throw new NullPointerException("null response");
        }
        try {
            sipResponse.checkHeaders();
        }
        catch (ParseException ex) {
            throw new IllegalTransactionStateException(ex.getMessage(), IllegalTransactionStateException.Reason.MissingRequiredHeader);
        }
        String responseMethod = sipResponse.getCSeq().getMethod();
        if (!responseMethod.equals(this.getMethod())) {
            throw new IllegalTransactionStateException("CSeq method does not match Request method of request that created the tx.", IllegalTransactionStateException.Reason.UnmatchingCSeq);
        }
        int statusCode = response.getStatusCode();
        if (this.getMethod().equals("SUBSCRIBE") && statusCode / 100 == 2) {
            if (response.getHeader("Expires") == null) {
                throw new IllegalTransactionStateException("Expires header is mandatory in 2xx response of SUBSCRIBE", IllegalTransactionStateException.Reason.ExpiresHeaderMandatory);
            }
            Expires requestExpires = (Expires)this.getOriginalRequest().getExpires();
            Expires responseExpires = (Expires)response.getExpires();
            if (requestExpires != null && responseExpires.getExpires() > requestExpires.getExpires()) {
                throw new SipException("Response Expires time exceeds request Expires time : See RFC 3265 3.1.1");
            }
        }
        if (statusCode == 200 && responseMethod.equals("INVITE") && sipResponse.getHeader("Contact") == null) {
            throw new IllegalTransactionStateException("Contact Header is mandatory for the OK to the INVITE", IllegalTransactionStateException.Reason.ContactHeaderMandatory);
        }
        if (!this.isMessagePartOfTransaction((SIPMessage)response)) {
            throw new SipException("Response does not belong to this transaction.");
        }
        try {
            block39: {
                ContentType contentTypeHeader = ((SIPResponse)response).getContentTypeHeader();
                if (this.pendingReliableResponseAsBytes != null && this.getDialog() != null && this.getInternalState() != 5 && statusCode / 100 == 2 && contentTypeHeader != null && contentTypeHeader.getContentType().equalsIgnoreCase(CONTENT_TYPE_APPLICATION) && contentTypeHeader.getContentSubType().equalsIgnoreCase(CONTENT_SUBTYPE_SDP)) {
                    if (!interlockProvisionalResponses) {
                        throw new SipException("cannot send response -- unacked provisional");
                    }
                    try {
                        boolean acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS);
                        if (!acquired) {
                            throw new SipException("cannot send response -- unacked provisional");
                        }
                        break block39;
                    }
                    catch (InterruptedException ex) {
                        logger.logError("Interrupted acuqiring PRACK sem");
                        throw new SipException("Cannot aquire PRACK sem");
                    }
                }
                if (this.pendingReliableResponseAsBytes != null && sipResponse.isFinalResponse()) {
                    this.sipStack.getTimer().cancel(this.provisionalResponseTask);
                    this.provisionalResponseTask = null;
                }
            }
            if (dialog != null) {
                if (statusCode / 100 == 2 && SIPTransactionStack.isDialogCreated(responseMethod)) {
                    if (dialog.getLocalTag() == null && sipResponse.getToTag() == null) {
                        sipResponse.getTo().setTag(Utils.getInstance().generateTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("assigning toTag : serverTransaction = " + this + " dialog " + dialog + " tag = " + dialog.getLocalTag());
                        }
                        sipResponse.setToTag(dialog.getLocalTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() != null && !dialog.getLocalTag().equals(sipResponse.getToTag())) {
                        throw new SipException("Tag mismatch dialogTag is " + dialog.getLocalTag() + " responseTag is " + sipResponse.getToTag());
                    }
                }
                if (!sipResponse.getCallId().getCallId().equals(dialog.getCallId().getCallId())) {
                    throw new SipException("Dialog mismatch!");
                }
            }
            String fromTag = this.originalRequestFromTag;
            if (this.getRequest() != null) {
                fromTag = ((SIPRequest)this.getRequest()).getFromTag();
            }
            if (fromTag != null && sipResponse.getFromTag() != null && !sipResponse.getFromTag().equals(fromTag)) {
                throw new SipException("From tag of request does not match response from tag");
            }
            if (fromTag != null) {
                sipResponse.getFrom().setTag(fromTag);
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("WARNING -- Null From tag in request!!");
            }
            if (dialog != null && statusCode != 100) {
                dialog.setResponseTags(sipResponse);
                DialogState oldState = dialog.getState();
                dialog.setLastResponse(this, (SIPResponse)response);
                if (oldState == null && dialog.getState() == DialogState.TERMINATED) {
                    DialogTerminatedEvent event = new DialogTerminatedEvent((Object)dialog.getSipProvider(), (Dialog)dialog);
                    dialog.getSipProvider().handleEvent((EventObject)event, this);
                }
            } else if (dialog == null && this.isInviteTransaction() && this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask == null && response.getStatusCode() / 100 == 2) {
                String dialogId = ((SIPResponse)response).getDialogId(true);
                this.retransmissionAlertTimerTask = new RetransmissionAlertTimerTask(dialogId);
                this.sipStack.retransmissionAlertTransactions.put(dialogId, this);
                this.sipStack.getTimer().scheduleWithFixedDelay(this.retransmissionAlertTimerTask, 0L, 500L);
            }
            this.sendMessage((SIPResponse)response);
            if (dialog != null) {
                dialog.startRetransmitTimer(this, (SIPResponse)response);
            }
        }
        catch (IOException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex);
            }
            this.setState(5);
            this.raiseErrorEvent(2);
            throw new SipException(ex.getMessage(), (Throwable)ex);
        }
        catch (ParseException ex1) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex1);
            }
            this.setState(5);
            throw new SipException(ex1.getMessage(), (Throwable)ex1);
        }
    }

    protected int getRealState() {
        return super.getInternalState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && 1 == super.getInternalState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(int newState) {
        if (newState == 5 && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
            this.terminationSemaphore.release();
        }
        super.setState(newState);
    }

    protected void startTransactionTimer() {
        if ((this.getMethod().equalsIgnoreCase("INVITE") || this.getMethod().equalsIgnoreCase("CANCEL") || this.getMethod().equalsIgnoreCase("ACK")) && this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
            TransactionTimer myTimer = new TransactionTimer();
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                this.sipStack.getTimer().scheduleWithFixedDelay(myTimer, this.BASE_TIMER_INTERVAL, this.BASE_TIMER_INTERVAL);
            }
            Object var1_1 = null;
        }
    }

    protected void startTransactionTimerJ(long time) {
        if (this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("starting TransactionTimerJ() : " + this.getTransactionId() + " time " + time);
            }
            SIPStackTimerTask task = new SIPStackTimerTask(){

                public void runTask() {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("executing TransactionTimerJ() : " + SIPServerTransaction.this.getTransactionId());
                    }
                    SIPServerTransaction.this.fireTimeoutTimer();
                    SIPServerTransaction.this.cleanUp();
                    if (SIPServerTransaction.this.originalRequest != null) {
                        SIPServerTransaction.this.originalRequest.cleanUp();
                    }
                }
            };
            if (time > 0L) {
                this.sipStack.getTimer().schedule(task, time * 1L * (long)this.BASE_TIMER_INTERVAL);
            } else {
                task.runTask();
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sst = (SIPServerTransaction)other;
        return this.getBranch().equalsIgnoreCase(sst.getBranch());
    }

    public Dialog getDialog() {
        if (this.dialog == null && this.dialogId != null) {
            return this.sipStack.getDialog(this.dialogId);
        }
        return this.dialog;
    }

    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setDialog " + this + " dialog = " + sipDialog);
        }
        this.dialog = sipDialog;
        this.dialogId = dialogId;
        if (dialogId != null) {
            sipDialog.setAssigned();
        }
        if (this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask != null) {
            this.sipStack.getTimer().cancel(this.retransmissionAlertTimerTask);
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        this.retransmissionAlertEnabled = false;
    }

    public void terminate() throws ObjectInUseException {
        this.setState(5);
        if (this.retransmissionAlertTimerTask != null) {
            this.sipStack.getTimer().cancel(this.retransmissionAlertTimerTask);
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        if (!this.transactionTimerStarted.get()) {
            this.testAndSetTransactionTerminatedEvent();
            this.sipStack.removeTransaction(this);
        }
    }

    protected void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (this.pendingReliableResponseAsBytes != null) {
            throw new SipException("Unacknowledged response");
        }
        SIPResponse reliableResponse = (SIPResponse)relResponse;
        this.pendingReliableResponseAsBytes = reliableResponse.encodeAsBytes(this.getTransport());
        this.pendingReliableResponseMethod = reliableResponse.getCSeq().getMethod();
        this.pendingReliableCSeqNumber = reliableResponse.getCSeq().getSeqNumber();
        RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
        if (relResponse.getHeader("RSeq") == null) {
            rseq = new RSeq();
            relResponse.setHeader((Header)rseq);
        }
        try {
            boolean acquired;
            if (this.rseqNumber < 0) {
                this.rseqNumber = (int)(Math.random() * 1000.0);
            }
            ++this.rseqNumber;
            rseq.setSeqNumber(this.rseqNumber);
            this.pendingReliableRSeqNumber = rseq.getSeqNumber();
            this.lastResponse = (SIPResponse)relResponse;
            if (this.getDialog() != null && interlockProvisionalResponses && !(acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS))) {
                throw new SipException("Unacknowledged reliable response");
            }
            this.provisionalResponseTask = new ProvisionalResponseTask();
            this.sipStack.getTimer().scheduleWithFixedDelay(this.provisionalResponseTask, 0L, 500L);
            this.sendMessage((SIPMessage)relResponse);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public byte[] getReliableProvisionalResponse() {
        return this.pendingReliableResponseAsBytes;
    }

    public boolean prackRecieved() {
        if (this.pendingReliableResponseAsBytes == null) {
            return false;
        }
        if (this.provisionalResponseTask != null) {
            this.sipStack.getTimer().cancel(this.provisionalResponseTask);
            this.provisionalResponseTask = null;
        }
        this.pendingReliableResponseAsBytes = null;
        if (interlockProvisionalResponses && this.getDialog() != null) {
            this.provisionalResponseSem.release();
        }
        return true;
    }

    public void enableRetransmissionAlerts() throws SipException {
        if (this.getDialog() != null) {
            throw new SipException("Dialog associated with tx");
        }
        if (!this.isInviteTransaction()) {
            throw new SipException("Request Method must be INVITE");
        }
        this.retransmissionAlertEnabled = true;
    }

    public boolean isRetransmissionAlertEnabled() {
        return this.retransmissionAlertEnabled;
    }

    public void disableRetransmissionAlerts() {
        if (this.retransmissionAlertTimerTask != null && this.retransmissionAlertEnabled) {
            this.sipStack.getTimer().cancel(this.retransmissionAlertTimerTask);
            this.retransmissionAlertEnabled = false;
            String dialogId = this.retransmissionAlertTimerTask.dialogId;
            if (dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setMapped(boolean b) {
        this.isMapped = true;
    }

    public void setPendingSubscribe(SIPClientTransaction pendingSubscribeClientTx) {
        this.pendingSubscribeTransaction = pendingSubscribeClientTx;
    }

    public void releaseSem() {
        if (this.pendingSubscribeTransaction != null) {
            if (!this.sipStack.isDeliverUnsolicitedNotify()) {
                this.pendingSubscribeTransaction.releaseSem();
            }
        } else if (this.inviteTransaction != null && this.getMethod().equals("CANCEL")) {
            this.inviteTransaction.releaseSem();
        }
        super.releaseSem();
    }

    public void setInviteTransaction(SIPServerTransaction st) {
        this.inviteTransaction = st;
    }

    public SIPServerTransaction getCanceledInviteTransaction() {
        return this.inviteTransaction;
    }

    public void scheduleAckRemoval() throws IllegalStateException {
        if (this.getMethod() == null || !this.getMethod().equals("ACK")) {
            throw new IllegalStateException("Method is null[" + (this.getMethod() == null) + "] or method is not ACK[" + this.getMethod() + "]");
        }
        this.startTransactionTimer();
    }

    public void cleanUp() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("removing" + this);
        }
        if (this.isReleaseReferences()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup : " + this.getTransactionId());
            }
            if (this.originalRequest == null && this.originalRequestBytes != null) {
                try {
                    this.originalRequest = (SIPRequest)this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack).parseSIPMessage(this.originalRequestBytes, true, false, null);
                }
                catch (ParseException e) {
                    logger.logError("message " + this.originalRequestBytes + "could not be reparsed !");
                }
            } else if (this.originalRequest != null && this.originalRequestBytes == null) {
                this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
            }
            this.sipStack.removeTransaction(this);
            this.cleanUpOnTimer();
            this.originalRequestFromTag = null;
            this.originalRequestSentBy = null;
            if (this.originalRequest != null) {
                this.originalRequest = null;
            }
            if (!this.isReliable() && this.inviteTransaction != null) {
                this.inviteTransaction = null;
            }
            this.lastResponse = null;
        } else {
            this.sipStack.removeTransaction(this);
        }
        if (!this.sipStack.cacheServerConnections && --this.getMessageChannel().useCount <= 0) {
            this.close();
        } else if (logger.isLoggingEnabled(32) && !this.sipStack.cacheServerConnections && this.isReliable()) {
            int useCount = this.getMessageChannel().useCount;
            logger.logDebug("Use Count = " + useCount);
        }
    }

    protected void cleanUpOnTimer() {
        if (this.isReleaseReferences()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanup on timer : " + this.getTransactionId());
            }
            if (this.dialog != null && this.getMethod().equals("CANCEL")) {
                this.dialogId = this.dialog.getDialogId();
            }
            this.dialog = null;
            if (this.inviteTransaction != null && !this.getMethod().equals("CANCEL")) {
                this.inviteTransaction.releaseSem();
                this.inviteTransaction = null;
            }
            if (this.originalRequest != null) {
                this.originalRequest.setTransaction(null);
                this.originalRequest.setInviteTransaction(null);
                if (!this.getMethod().equalsIgnoreCase("INVITE")) {
                    if (this.originalRequestSentBy == null) {
                        this.originalRequestSentBy = this.originalRequest.getTopmostVia().getSentBy();
                    }
                    if (this.originalRequestFromTag == null) {
                        this.originalRequestFromTag = this.originalRequest.getFromTag();
                    }
                }
                if (this.originalRequestBytes == null) {
                    this.originalRequestBytes = this.originalRequest.encodeAsBytes(this.getTransport());
                }
                if (!this.getMethod().equalsIgnoreCase("INVITE") && !this.getMethod().equalsIgnoreCase("CANCEL")) {
                    this.originalRequest = null;
                }
            }
            if (this.lastResponse != null) {
                this.lastResponseAsBytes = this.lastResponse.encodeAsBytes(this.getTransport());
                this.lastResponse = null;
            }
            this.pendingReliableResponseAsBytes = null;
            this.pendingReliableResponseMethod = null;
            this.pendingSubscribeTransaction = null;
            this.provisionalResponseSem = null;
            this.retransmissionAlertTimerTask = null;
            this.requestOf = null;
            this.messageProcessor = null;
        }
    }

    public String getPendingReliableResponseMethod() {
        return this.pendingReliableResponseMethod;
    }

    public long getPendingReliableCSeqNumber() {
        return this.pendingReliableCSeqNumber;
    }

    public long getPendingReliableRSeqNumber() {
        return this.pendingReliableRSeqNumber;
    }

    public void waitForTermination() {
        try {
            this.terminationSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class TransactionTimer
    extends SIPStackTimerTask {
        public TransactionTimer() {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TransactionTimer() : " + SIPServerTransaction.this.getTransactionId());
            }
        }

        public void runTask() {
            if (SIPServerTransaction.this.isTerminated()) {
                block6: {
                    try {
                        SIPServerTransaction.this.sipStack.getTimer().cancel(this);
                        if (SIPServerTransaction.this.listenerExecutionMaxTimer != null) {
                            SIPServerTransaction.this.sipStack.getTimer().cancel(SIPServerTransaction.this.listenerExecutionMaxTimer);
                        }
                    }
                    catch (IllegalStateException ex) {
                        if (SIPServerTransaction.this.sipStack.isAlive()) break block6;
                        return;
                    }
                }
                SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer(SIPServerTransaction.this);
                SIPServerTransaction.this.sipStack.getTimer().schedule(myTimer, 8000L);
            } else {
                SIPServerTransaction.this.fireTimer();
            }
            if (SIPServerTransaction.this.originalRequest != null) {
                SIPServerTransaction.this.originalRequest.cleanUp();
            }
        }
    }

    class SendTrying
    extends SIPStackTimerTask {
        protected SendTrying() {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("scheduled timer for " + SIPServerTransaction.this);
            }
        }

        public void runTask() {
            block5: {
                SIPServerTransaction serverTransaction = SIPServerTransaction.this;
                int realState = serverTransaction.getRealState();
                if (realState < 0 || 1 == realState) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug(" sending Trying current state = " + serverTransaction.getRealState());
                    }
                    try {
                        serverTransaction.sendMessage(serverTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug(" trying sent " + serverTransaction.getRealState());
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggingEnabled()) break block5;
                        logger.logError("IO error sending  TRYING");
                    }
                }
            }
        }
    }

    class ListenerExecutionMaxTimer
    extends SIPStackTimerTask {
        SIPServerTransaction serverTransaction;

        ListenerExecutionMaxTimer() {
            this.serverTransaction = SIPServerTransaction.this;
        }

        public void runTask() {
            try {
                SIPServerTransaction.this.listenerExecutionMaxTimer = null;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Fired ListenerExecutionMaxTimer for stx " + this.serverTransaction.getTransactionId() + " state " + this.serverTransaction.getState());
                }
                this.serverTransaction.terminate();
                SIPTransactionStack sipStack = this.serverTransaction.getSIPStack();
                sipStack.removePendingTransaction(this.serverTransaction);
                sipStack.removeTransaction(this.serverTransaction);
            }
            catch (Exception ex) {
                logger.logError("unexpected exception", ex);
            }
        }
    }

    class ProvisionalResponseTask
    extends SIPStackTimerTask {
        int ticks;
        int ticksLeft;

        public ProvisionalResponseTask() {
            this.ticksLeft = this.ticks = 1;
        }

        public void runTask() {
            SIPServerTransaction serverTransaction = SIPServerTransaction.this;
            if (serverTransaction.isTerminated()) {
                SIPServerTransaction.this.sipStack.getTimer().cancel(this);
            } else {
                --this.ticksLeft;
                if (this.ticksLeft == -1) {
                    serverTransaction.fireReliableResponseRetransmissionTimer();
                    this.ticks = this.ticksLeft = 2 * this.ticks;
                    if (this.ticksLeft >= 64) {
                        SIPServerTransaction.this.sipStack.getTimer().cancel(this);
                        SIPServerTransaction.this.setState(5);
                        SIPServerTransaction.this.fireTimeoutTimer();
                    }
                }
            }
        }
    }

    class RetransmissionAlertTimerTask
    extends SIPStackTimerTask {
        String dialogId;
        int ticks;
        int ticksLeft;

        public RetransmissionAlertTimerTask(String dialogId) {
            this.ticksLeft = this.ticks = 1;
        }

        public void runTask() {
            SIPServerTransaction serverTransaction = SIPServerTransaction.this;
            --this.ticksLeft;
            if (this.ticksLeft == -1) {
                serverTransaction.fireRetransmissionTimer();
                this.ticksLeft = 2 * this.ticks;
            }
        }
    }
}

