/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class FileTypeMap {
    private static FileTypeMap defaultMap = null;
    private static Map<ClassLoader, FileTypeMap> map = new WeakHashMap<ClassLoader, FileTypeMap>();

    public abstract String getContentType(File var1);

    public abstract String getContentType(Path var1);

    public abstract String getContentType(String var1);

    public static synchronized void setDefaultFileTypeMap(FileTypeMap fileTypeMap) {
        map.remove(Thread.currentThread().getContextClassLoader());
        defaultMap = fileTypeMap;
    }

    public static synchronized FileTypeMap getDefaultFileTypeMap() {
        if (defaultMap != null) {
            return defaultMap;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        FileTypeMap def = map.get(tccl);
        if (def == null) {
            def = new MimetypesFileTypeMap();
            map.put(tccl, def);
        }
        return def;
    }
}

