/*
 * Decompiled with CFR 0.152.
 */
package it.unibo.tuprolog.collections.rete.custom.nodes;

import it.unibo.tuprolog.collections.rete.custom.Cacheable;
import it.unibo.tuprolog.collections.rete.custom.ReteTree;
import it.unibo.tuprolog.collections.rete.custom.Utils;
import it.unibo.tuprolog.collections.rete.custom.clause.IndexedClause;
import it.unibo.tuprolog.collections.rete.custom.leaf.DirectiveIndex;
import it.unibo.tuprolog.collections.rete.custom.nodes.RootNode;
import it.unibo.tuprolog.collections.rete.custom.nodes.RuleNode;
import it.unibo.tuprolog.core.Clause;
import it.unibo.tuprolog.utils.Cached;
import it.unibo.tuprolog.utils.DequeKt;
import it.unibo.tuprolog.utils.IterUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lit/unibo/tuprolog/collections/rete/custom/nodes/RootNode;", "Lit/unibo/tuprolog/collections/rete/custom/ReteTree;", "Lit/unibo/tuprolog/collections/rete/custom/Cacheable;", "Lit/unibo/tuprolog/core/Clause;", "clauses", "", "isOrdered", "", "(Ljava/lang/Iterable;Z)V", "Lkotlin/sequences/Sequence;", "getClauses", "()Lkotlin/sequences/Sequence;", "directives", "Lit/unibo/tuprolog/collections/rete/custom/leaf/DirectiveIndex;", "highestIndex", "", "()Z", "lowestIndex", "rules", "Lit/unibo/tuprolog/collections/rete/custom/nodes/RuleNode;", "theoryCache", "Lit/unibo/tuprolog/utils/Cached;", "", "assertA", "", "clause", "assertZ", "assignHigherIndex", "Lit/unibo/tuprolog/collections/rete/custom/clause/IndexedClause;", "assignLowerIndex", "deepCopy", "get", "getCache", "invalidateCache", "regenerateCache", "retractAll", "retractFirst", "retractOnly", "limit", "", "theory"})
public final class RootNode
implements ReteTree,
Cacheable<Clause> {
    private final boolean isOrdered;
    @NotNull
    private final Cached<List<Clause>> theoryCache;
    @NotNull
    private final RuleNode rules;
    @NotNull
    private final DirectiveIndex directives;
    private long lowestIndex;
    private long highestIndex;

    public RootNode(@NotNull Iterable<? extends Clause> clauses, boolean isOrdered) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        this.isOrdered = isOrdered;
        this.theoryCache = Cached.Companion.of((Function0)new Function0<List<Clause>>((Object)this){

            @NotNull
            public final List<Clause> invoke() {
                return RootNode.access$regenerateCache((RootNode)this.receiver);
            }
        });
        this.rules = new RuleNode(this.isOrdered());
        this.directives = new DirectiveIndex(this.isOrdered());
        Iterable<? extends Clause> $this$forEach$iv = clauses;
        boolean $i$f$forEach = false;
        Iterator<? extends Clause> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Clause element$iv;
            Clause it = element$iv = iterator.next();
            boolean bl = false;
            this.assertZ(it);
        }
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    @NotNull
    public Sequence<Clause> getClauses() {
        return CollectionsKt.asSequence((Iterable)((Iterable)this.theoryCache.getValue()));
    }

    @Override
    @NotNull
    public Sequence<Clause> get(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return clause.isDirective() ? this.directives.get(clause) : this.rules.get(clause);
    }

    @Override
    @NotNull
    public Sequence<Clause> retractFirst(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return clause.isDirective() ? this.directives.retractFirst(clause) : this.rules.retractFirst(clause);
    }

    @Override
    @NotNull
    public Sequence<Clause> retractOnly(@NotNull Clause clause, int limit) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return IterUtils.buffered((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(1, limit))), (Function1)((Function1)new Function1<Integer, Sequence<? extends Clause>>(this, clause){
            final /* synthetic */ RootNode this$0;
            final /* synthetic */ Clause $clause;
            {
                this.this$0 = $receiver;
                this.$clause = $clause;
                super(1);
            }

            @NotNull
            public final Sequence<Clause> invoke(int it) {
                return this.this$0.retractFirst(this.$clause);
            }
        })));
    }

    @Override
    @NotNull
    public Sequence<Clause> retractAll(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        return clause.isDirective() ? this.directives.retractAll(clause) : this.rules.retractAll(clause);
    }

    @Override
    @NotNull
    public ReteTree deepCopy() {
        return new RootNode(SequencesKt.asIterable(this.getClauses()), this.isOrdered());
    }

    @Override
    public void assertA(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        IndexedClause indexed = this.assignLowerIndex(clause);
        if (this.isOrdered()) {
            this.theoryCache.ifValid((Function1)new Function1<List<Clause>, Unit>(clause){
                final /* synthetic */ Clause $clause;
                {
                    this.$clause = $clause;
                    super(1);
                }

                public final void invoke(@NotNull List<Clause> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    DequeKt.addFirst(it, (Object)this.$clause);
                }
            });
            if (clause.isDirective()) {
                this.directives.assertA(indexed);
            } else {
                this.rules.assertA(indexed);
            }
        } else {
            throw new UnsupportedOperationException("An unordered ReteTree cannot perform the assertA operation.");
        }
    }

    @Override
    public void assertZ(@NotNull Clause clause) {
        Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
        IndexedClause indexed = this.assignHigherIndex(clause);
        this.theoryCache.ifValid((Function1)new Function1<List<Clause>, Boolean>(clause){
            final /* synthetic */ Clause $clause;
            {
                this.$clause = $clause;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull List<Clause> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.add(this.$clause);
            }
        });
        if (clause.isDirective()) {
            this.directives.assertZ(indexed);
        } else {
            this.rules.assertZ(indexed);
        }
    }

    private final IndexedClause assignHigherIndex(Clause clause) {
        Cacheable[] cacheableArray = this;
        ++cacheableArray.highestIndex;
        cacheableArray = new Cacheable[]{(Cacheable)this};
        return IndexedClause.Companion.of(cacheableArray.highestIndex, clause, cacheableArray);
    }

    private final IndexedClause assignLowerIndex(Clause clause) {
        Cacheable[] cacheableArray = this;
        cacheableArray.lowestIndex += -1L;
        cacheableArray = new Cacheable[]{(Cacheable)this};
        return IndexedClause.Companion.of(cacheableArray.lowestIndex, clause, cacheableArray);
    }

    private final List<Clause> regenerateCache() {
        Sequence<Clause> sequence;
        if (this.isOrdered()) {
            Sequence[] sequenceArray = new Sequence[]{this.directives.getCache(), this.rules.getCache()};
            sequence = SequencesKt.map(Utils.INSTANCE.merge(sequenceArray), (Function1)regenerateCache.1.INSTANCE);
        } else {
            Sequence[] sequenceArray = new Sequence[]{SequencesKt.map(this.directives.getCache(), (Function1)regenerateCache.2.INSTANCE), SequencesKt.map(this.rules.getCache(), (Function1)regenerateCache.3.INSTANCE)};
            sequence = Utils.INSTANCE.flatten(sequenceArray);
        }
        return DequeKt.dequeOf((Sequence)sequence);
    }

    @Override
    @NotNull
    public Sequence<Clause> getCache() {
        return CollectionsKt.asSequence((Iterable)((Iterable)this.theoryCache.getValue()));
    }

    @Override
    public void invalidateCache() {
        this.theoryCache.invalidate();
    }

    @Override
    public boolean contains(@NotNull Clause clause) {
        return ReteTree.DefaultImpls.contains(this, clause);
    }

    @Override
    public int getSize() {
        return ReteTree.DefaultImpls.getSize(this);
    }

    public static final /* synthetic */ List access$regenerateCache(RootNode $this) {
        return $this.regenerateCache();
    }
}

