/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.LocalTracer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;

public enum BootstrapTrace {
    INSTANCE;

    private final Map<String, Long> annotations = new LinkedHashMap<String, Long>();
    private final long timestamp = System.currentTimeMillis() * 1000L;
    private final long startTick = System.nanoTime();

    public void record(ApplicationEvent event) {
        this.annotations.put(event.getClass().getSimpleName().replace("Event", ""), this.timestamp + this.microsSinceInit());
        if (event instanceof ApplicationReadyEvent) {
            long duration = this.microsSinceInit();
            ApplicationReadyEvent ready = (ApplicationReadyEvent)event;
            try {
                LocalTracer tracer = ((Brave)ready.getApplicationContext().getBeanFactory().getBean(Brave.class)).localTracer();
                tracer.startNewSpan("spring-boot", "bootstrap", this.timestamp);
                this.annotations.forEach((arg_0, arg_1) -> ((LocalTracer)tracer).submitAnnotation(arg_0, arg_1));
                tracer.finishSpan(duration);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    private long microsSinceInit() {
        return (System.nanoTime() - this.startTick) / 1000L;
    }
}

