/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.spring.ServletHandlerInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import zipkin.server.ConditionalOnSelfTracing;

@ConditionalOnSelfTracing
@Configuration
public class ApiTracerConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    Brave brave;

    public void addInterceptors(InterceptorRegistry registry) {
        ServerTracer tracer = this.brave.serverTracer();
        ServletHandlerInterceptor traceInterceptor = new ServletHandlerInterceptor(new ServerRequestInterceptor(tracer), new ServerResponseInterceptor(tracer), (SpanNameProvider)new DefaultSpanNameProvider(), this.brave.serverSpanThreadBinder());
        registry.addInterceptor((HandlerInterceptor)traceInterceptor);
    }
}

