/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import com.github.kristofa.brave.Brave;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.server.ActuateCollectorMetrics;
import zipkin.server.ConditionalOnSelfTracing;
import zipkin.server.ZipkinHealthIndicator;
import zipkin.server.brave.TracedStorageComponent;
import zipkin.storage.InMemoryStorage;
import zipkin.storage.StorageComponent;

@Configuration
public class ZipkinServerConfiguration {
    @Bean
    ZipkinHealthIndicator zipkinHealthIndicator(HealthAggregator healthAggregator) {
        return new ZipkinHealthIndicator(healthAggregator);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorSampler.class})
    CollectorSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate:1.0}") float rate) {
        return CollectorSampler.create((float)rate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorMetrics.class})
    CollectorMetrics metrics(CounterService counterService, GaugeService gaugeService) {
        return new ActuateCollectorMetrics(counterService, gaugeService);
    }

    @Configuration
    @ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mem", matchIfMissing=true)
    @ConditionalOnMissingBean(value={StorageComponent.class})
    static class InMemoryConfiguration {
        InMemoryConfiguration() {
        }

        @Bean
        StorageComponent storage() {
            return new InMemoryStorage();
        }
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class BraveTracedStorageComponentEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Brave brave;

        BraveTracedStorageComponentEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof TracedStorageComponent && this.brave != null) {
                return new TracedStorageComponent(this.brave, (TracedStorageComponent)bean);
            }
            return bean;
        }
    }
}

