/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import zipkin.Codec;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.Nullable;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

@RestController
public class ZipkinHttpCollector {
    static final ResponseEntity<?> SUCCESS = ResponseEntity.accepted().build();
    static final String APPLICATION_THRIFT = "application/x-thrift";
    final CollectorMetrics metrics;
    final Collector collector;
    private static final ThreadLocal<byte[]> GZIP_BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    };

    @Autowired
    ZipkinHttpCollector(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        this.metrics = metrics.forTransport("http");
        this.collector = Collector.builder(this.getClass()).storage(storage).sampler(sampler).metrics(this.metrics).build();
    }

    @RequestMapping(value={"/api/v1/spans"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public DeferredResult<ResponseEntity<?>> uploadSpansJson(@RequestHeader(value="Content-Encoding", required=false) String encoding, @RequestBody byte[] body) {
        return this.validateAndStoreSpans(encoding, (Codec)Codec.JSON, body);
    }

    @RequestMapping(value={"/api/v1/spans"}, method={RequestMethod.POST}, consumes={"application/x-thrift"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public DeferredResult<ResponseEntity<?>> uploadSpansThrift(@RequestHeader(value="Content-Encoding", required=false) String encoding, @RequestBody byte[] body) {
        return this.validateAndStoreSpans(encoding, (Codec)Codec.THRIFT, body);
    }

    DeferredResult<ResponseEntity<?>> validateAndStoreSpans(String encoding, Codec codec, byte[] body) {
        final DeferredResult result = new DeferredResult();
        this.metrics.incrementMessages();
        if (encoding != null && encoding.contains("gzip")) {
            try {
                body = ZipkinHttpCollector.gunzip(body);
            }
            catch (IOException e) {
                this.metrics.incrementMessagesDropped();
                result.setResult((Object)ResponseEntity.badRequest().body((Object)"Cannot gunzip spans\n"));
                return result;
            }
        }
        this.collector.acceptSpans(body, codec, (Callback)new Callback<Void>(){

            public void onSuccess(@Nullable Void value) {
                result.setResult(SUCCESS);
            }

            public void onError(Throwable t) {
                String message = t.getMessage();
                result.setErrorResult((Object)(message.startsWith("Cannot store") ? ResponseEntity.status((int)500).body((Object)(message + "\n")) : ResponseEntity.status((int)400).body((Object)(message + "\n"))));
            }
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] gunzip(byte[] input) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(input);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length);){
            while (!inflater.finished()) {
                int count = inflater.inflate(GZIP_BUFFER.get());
                outputStream.write(GZIP_BUFFER.get(), 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (DataFormatException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

