/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Tracing;
import brave.spring.rabbit.TracingMessagePostProcessor;
import brave.spring.rabbit.TracingRabbitListenerAdvice;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public final class SpringRabbitTracing {
    static final String RABBIT_EXCHANGE = "rabbit.exchange";
    static final String RABBIT_ROUTING_KEY = "rabbit.routing_key";
    static final String RABBIT_QUEUE = "rabbit.queue";
    final TracingMessagePostProcessor tracingMessagePostProcessor;
    final TracingRabbitListenerAdvice tracingRabbitListenerAdvice;
    final Field beforePublishPostProcessorsField;

    public static SpringRabbitTracing create(Tracing tracing) {
        if (tracing == null) {
            throw new NullPointerException("tracing == null");
        }
        return new Builder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    SpringRabbitTracing(Builder builder) {
        Tracing tracing = builder.tracing;
        String remoteServiceName = builder.remoteServiceName;
        this.tracingMessagePostProcessor = new TracingMessagePostProcessor(tracing, remoteServiceName);
        this.tracingRabbitListenerAdvice = new TracingRabbitListenerAdvice(tracing, remoteServiceName);
        Field beforePublishPostProcessorsField = null;
        try {
            beforePublishPostProcessorsField = RabbitTemplate.class.getDeclaredField("beforePublishPostProcessors");
            beforePublishPostProcessorsField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.beforePublishPostProcessorsField = beforePublishPostProcessorsField;
    }

    public RabbitTemplate newRabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{this.tracingMessagePostProcessor});
        return rabbitTemplate;
    }

    public RabbitTemplate decorateRabbitTemplate(RabbitTemplate rabbitTemplate) {
        Collection processors;
        if (this.beforePublishPostProcessorsField == null) {
            return rabbitTemplate;
        }
        try {
            processors = (Collection)this.beforePublishPostProcessorsField.get(rabbitTemplate);
        }
        catch (IllegalAccessException e) {
            return rabbitTemplate;
        }
        if (processors == null) {
            rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{this.tracingMessagePostProcessor});
            return rabbitTemplate;
        }
        for (MessagePostProcessor processor : processors) {
            if (!(processor instanceof TracingMessagePostProcessor)) continue;
            return rabbitTemplate;
        }
        ArrayList<TracingMessagePostProcessor> newProcessors = new ArrayList<TracingMessagePostProcessor>(processors.size() + 1);
        newProcessors.addAll(processors);
        newProcessors.add(this.tracingMessagePostProcessor);
        rabbitTemplate.setBeforePublishPostProcessors(newProcessors.toArray(new MessagePostProcessor[0]));
        return rabbitTemplate;
    }

    public SimpleRabbitListenerContainerFactory newSimpleRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAdviceChain(new Advice[]{this.tracingRabbitListenerAdvice});
        return factory;
    }

    public SimpleRabbitListenerContainerFactory decorateSimpleRabbitListenerContainerFactory(SimpleRabbitListenerContainerFactory factory) {
        Advice[] chain = factory.getAdviceChain();
        if (chain == null) {
            factory.setAdviceChain(new Advice[]{this.tracingRabbitListenerAdvice});
            return factory;
        }
        for (Advice advice : chain) {
            if (!(advice instanceof TracingRabbitListenerAdvice)) continue;
            return factory;
        }
        Advice[] newChain = new Advice[chain.length + 1];
        System.arraycopy(chain, 0, newChain, 0, chain.length);
        newChain[chain.length] = this.tracingRabbitListenerAdvice;
        factory.setAdviceChain(newChain);
        return factory;
    }

    public static final class Builder {
        final Tracing tracing;
        String remoteServiceName = "rabbitmq";

        Builder(Tracing tracing) {
            this.tracing = tracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public SpringRabbitTracing build() {
            return new SpringRabbitTracing(this);
        }
    }
}

