// Generated by delombok at Tue Aug 22 16:14:12 UTC 2023
package io.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import java.util.Set;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HybridArgument implements Argument {
  private final String query;
  private final Float alpha;
  private final Float[] vector;
  private final String fusionType;
  private final String[] properties;

  @Override
  public String build() {
    Set<String> arg = new LinkedHashSet<>();
    arg.add(String.format("query:%s", Serializer.quote(query)));
    if (vector != null) {
      arg.add(String.format("vector:%s", Serializer.array(vector)));
    }
    if (alpha != null) {
      arg.add(String.format("alpha:%s", alpha));
    }
    if (ArrayUtils.isNotEmpty(properties)) {
      arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(properties)));
    }
    if (StringUtils.isNotBlank(fusionType)) {
      arg.add(String.format("fusionType:%s", fusionType));
    }
    return String.format("hybrid:{%s}", String.join(" ", arg));
  }

  @java.lang.SuppressWarnings("all")
  HybridArgument(final String query, final Float alpha, final Float[] vector, final String fusionType, final String[] properties) {
    this.query = query;
    this.alpha = alpha;
    this.vector = vector;
    this.fusionType = fusionType;
    this.properties = properties;
  }


  @java.lang.SuppressWarnings("all")
  public static class HybridArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private String query;
    @java.lang.SuppressWarnings("all")
    private Float alpha;
    @java.lang.SuppressWarnings("all")
    private Float[] vector;
    @java.lang.SuppressWarnings("all")
    private String fusionType;
    @java.lang.SuppressWarnings("all")
    private String[] properties;

    @java.lang.SuppressWarnings("all")
    HybridArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public HybridArgument.HybridArgumentBuilder query(final String query) {
      this.query = query;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public HybridArgument.HybridArgumentBuilder alpha(final Float alpha) {
      this.alpha = alpha;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public HybridArgument.HybridArgumentBuilder vector(final Float[] vector) {
      this.vector = vector;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public HybridArgument.HybridArgumentBuilder fusionType(final String fusionType) {
      this.fusionType = fusionType;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public HybridArgument.HybridArgumentBuilder properties(final String[] properties) {
      this.properties = properties;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public HybridArgument build() {
      return new HybridArgument(this.query, this.alpha, this.vector, this.fusionType, this.properties);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "HybridArgument.HybridArgumentBuilder(query=" + this.query + ", alpha=" + this.alpha + ", vector=" + java.util.Arrays.deepToString(this.vector) + ", fusionType=" + this.fusionType + ", properties=" + java.util.Arrays.deepToString(this.properties) + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static HybridArgument.HybridArgumentBuilder builder() {
    return new HybridArgument.HybridArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getQuery() {
    return this.query;
  }

  @java.lang.SuppressWarnings("all")
  public Float getAlpha() {
    return this.alpha;
  }

  @java.lang.SuppressWarnings("all")
  public Float[] getVector() {
    return this.vector;
  }

  @java.lang.SuppressWarnings("all")
  public String getFusionType() {
    return this.fusionType;
  }

  @java.lang.SuppressWarnings("all")
  public String[] getProperties() {
    return this.properties;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "HybridArgument(query=" + this.getQuery() + ", alpha=" + this.getAlpha() + ", vector=" + java.util.Arrays.deepToString(this.getVector()) + ", fusionType=" + this.getFusionType() + ", properties=" + java.util.Arrays.deepToString(this.getProperties()) + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HybridArgument)) return false;
    final HybridArgument other = (HybridArgument) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$alpha = this.getAlpha();
    final java.lang.Object other$alpha = other.getAlpha();
    if (this$alpha == null ? other$alpha != null : !this$alpha.equals(other$alpha)) return false;
    final java.lang.Object this$query = this.getQuery();
    final java.lang.Object other$query = other.getQuery();
    if (this$query == null ? other$query != null : !this$query.equals(other$query)) return false;
    if (!java.util.Arrays.deepEquals(this.getVector(), other.getVector())) return false;
    final java.lang.Object this$fusionType = this.getFusionType();
    final java.lang.Object other$fusionType = other.getFusionType();
    if (this$fusionType == null ? other$fusionType != null : !this$fusionType.equals(other$fusionType)) return false;
    if (!java.util.Arrays.deepEquals(this.getProperties(), other.getProperties())) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof HybridArgument;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $alpha = this.getAlpha();
    result = result * PRIME + ($alpha == null ? 43 : $alpha.hashCode());
    final java.lang.Object $query = this.getQuery();
    result = result * PRIME + ($query == null ? 43 : $query.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getVector());
    final java.lang.Object $fusionType = this.getFusionType();
    result = result * PRIME + ($fusionType == null ? 43 : $fusionType.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getProperties());
    return result;
  }
}
