// Generated by delombok at Tue Aug 22 16:14:12 UTC 2023
package io.weaviate.client.v1.batch.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.v1.batch.model.BatchDeleteResponse;
import io.weaviate.client.v1.batch.util.ObjectsPath;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.filters.WhereFilter;

public class ObjectsBatchDeleter extends BaseClient<BatchDeleteResponse> implements ClientResult<BatchDeleteResponse> {
  private final ObjectsPath objectsPath;
  private String className;
  private String consistencyLevel;
  private String tenant;
  private WhereFilter where;
  private String output;
  private Boolean dryRun;

  public ObjectsBatchDeleter(HttpClient httpClient, Config config, ObjectsPath objectsPath) {
    super(httpClient, config);
    this.objectsPath = objectsPath;
  }

  public ObjectsBatchDeleter withClassName(String className) {
    this.className = className;
    return this;
  }

  public ObjectsBatchDeleter withConsistencyLevel(String consistencyLevel) {
    this.consistencyLevel = consistencyLevel;
    return this;
  }

  public ObjectsBatchDeleter withTenant(String tenant) {
    this.tenant = tenant;
    return this;
  }

  public ObjectsBatchDeleter withWhere(WhereFilter where) {
    this.where = where;
    return this;
  }

  public ObjectsBatchDeleter withOutput(String output) {
    this.output = output;
    return this;
  }

  public ObjectsBatchDeleter withDryRun(Boolean dryRun) {
    this.dryRun = dryRun;
    return this;
  }

  @Override
  public Result<BatchDeleteResponse> run() {
    BatchDeleteMatch match = BatchDeleteMatch.builder().className(className).whereFilter(where).build();
    BatchDelete batchDelete = BatchDelete.builder().dryRun(dryRun).output(output).match(match).build();
    String path = objectsPath.buildDelete(ObjectsPath.Params.builder().consistencyLevel(consistencyLevel).tenant(tenant).build());
    Response<BatchDeleteResponse> resp = sendDeleteRequest(path, batchDelete, BatchDeleteResponse.class);
    return new Result<>(resp);
  }


  private static class BatchDelete {
    BatchDeleteMatch match;
    String output;
    Boolean dryRun;

    @java.lang.SuppressWarnings("all")
    BatchDelete(final BatchDeleteMatch match, final String output, final Boolean dryRun) {
      this.match = match;
      this.output = output;
      this.dryRun = dryRun;
    }


    @java.lang.SuppressWarnings("all")
    public static class BatchDeleteBuilder {
      @java.lang.SuppressWarnings("all")
      private BatchDeleteMatch match;
      @java.lang.SuppressWarnings("all")
      private String output;
      @java.lang.SuppressWarnings("all")
      private Boolean dryRun;

      @java.lang.SuppressWarnings("all")
      BatchDeleteBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder match(final BatchDeleteMatch match) {
        this.match = match;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder output(final String output) {
        this.output = output;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder dryRun(final Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDelete build() {
        return new ObjectsBatchDeleter.BatchDelete(this.match, this.output, this.dryRun);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder(match=" + this.match + ", output=" + this.output + ", dryRun=" + this.dryRun + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder builder() {
      return new ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public BatchDeleteMatch getMatch() {
      return this.match;
    }

    @java.lang.SuppressWarnings("all")
    public String getOutput() {
      return this.output;
    }

    @java.lang.SuppressWarnings("all")
    public Boolean getDryRun() {
      return this.dryRun;
    }
  }


  private static class BatchDeleteMatch {
    @SerializedName("class")
    String className;
    @SerializedName("where")
    WhereFilter whereFilter;

    @java.lang.SuppressWarnings("all")
    BatchDeleteMatch(final String className, final WhereFilter whereFilter) {
      this.className = className;
      this.whereFilter = whereFilter;
    }


    @java.lang.SuppressWarnings("all")
    public static class BatchDeleteMatchBuilder {
      @java.lang.SuppressWarnings("all")
      private String className;
      @java.lang.SuppressWarnings("all")
      private WhereFilter whereFilter;

      @java.lang.SuppressWarnings("all")
      BatchDeleteMatchBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder className(final String className) {
        this.className = className;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder whereFilter(final WhereFilter whereFilter) {
        this.whereFilter = whereFilter;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsBatchDeleter.BatchDeleteMatch build() {
        return new ObjectsBatchDeleter.BatchDeleteMatch(this.className, this.whereFilter);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder(className=" + this.className + ", whereFilter=" + this.whereFilter + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder builder() {
      return new ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public String getClassName() {
      return this.className;
    }

    @java.lang.SuppressWarnings("all")
    public WhereFilter getWhereFilter() {
      return this.whereFilter;
    }
  }
}
