/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import io.wcm.sling.commons.caservice.PathPreprocessor;
import io.wcm.sling.commons.caservice.impl.ContextAwareServiceTracker;
import io.wcm.sling.commons.caservice.impl.ResolveAllResultImpl;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContextAwareServiceResolver.class}, immediate=true)
public class ContextAwareServiceResolverImpl
implements ContextAwareServiceResolver {
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private PathPreprocessor pathPreprocessor;
    private BundleContext bundleContext;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceResolverImpl.class);
    private LoadingCache<String, ContextAwareServiceTracker> serviceTrackerCache;

    @Activate
    private void activate(BundleContext context) {
        this.bundleContext = context;
        this.serviceTrackerCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, ContextAwareServiceTracker>(){

            public void onRemoval(RemovalNotification<String, ContextAwareServiceTracker> notification) {
                ((ContextAwareServiceTracker)notification.getValue()).dispose();
            }
        }).build((CacheLoader)new CacheLoader<String, ContextAwareServiceTracker>(){

            public ContextAwareServiceTracker load(String className) {
                return new ContextAwareServiceTracker(className, ContextAwareServiceResolverImpl.this.bundleContext, ContextAwareServiceResolverImpl.this.pathPreprocessor);
            }
        });
    }

    @Deactivate
    private void deactivate() {
        this.serviceTrackerCache.invalidateAll();
    }

    @Override
    public <T extends ContextAwareService> T resolve(@NotNull Class<T> serviceClass, @NotNull Adaptable adaptable) {
        Resource resource = this.getResource(adaptable);
        if (log.isTraceEnabled()) {
            log.trace("Resolve {} for resource {}", (Object)serviceClass.getName(), (Object)(resource != null ? resource.getPath() : "null"));
        }
        ContextAwareServiceTracker serviceTracker = this.getServiceTracker(serviceClass);
        return (T)((ContextAwareService)serviceTracker.resolve(resource).map(serviceInfo -> serviceInfo.getService()).findFirst().orElse(null));
    }

    @Override
    @NotNull
    public <T extends ContextAwareService> ContextAwareServiceResolver.ResolveAllResult<T> resolveAll(@NotNull Class<T> serviceClass, @NotNull Adaptable adaptable) {
        Resource resource = this.getResource(adaptable);
        if (log.isTraceEnabled()) {
            log.trace("Resolve all {} for resource {}", (Object)serviceClass.getName(), (Object)(resource != null ? resource.getPath() : "null"));
        }
        ContextAwareServiceTracker serviceTracker = this.getServiceTracker(serviceClass);
        return new ResolveAllResultImpl<ContextAwareService>(serviceTracker.resolve(resource).map(serviceInfo -> serviceInfo.getService()), () -> this.buildCombinedKey(serviceTracker, serviceTracker.resolve(resource)));
    }

    private String buildCombinedKey(ContextAwareServiceTracker serviceTracker, Stream<ServiceInfo> result) {
        return serviceTracker.getLastServiceChangeTimestamp() + "\n" + result.map(ServiceInfo::getKey).collect(Collectors.joining("\n~\n"));
    }

    private Resource getResource(Adaptable adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            ComponentContext wcmComponentContext = WCMUtils.getComponentContext((ServletRequest)request);
            if (wcmComponentContext != null && wcmComponentContext.getPage() != null) {
                return wcmComponentContext.getPage().getContentResource();
            }
            return request.getResource();
        }
        return null;
    }

    private ContextAwareServiceTracker getServiceTracker(Class<?> serviceClass) {
        try {
            return (ContextAwareServiceTracker)this.serviceTrackerCache.get((Object)serviceClass.getName());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error getting service tracker for " + serviceClass.getName() + " from cache.", ex);
        }
    }

    ConcurrentMap<String, ContextAwareServiceTracker> getContextAwareServiceTrackerMap() {
        return this.serviceTrackerCache.asMap();
    }
}

