/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.util;

import com.google.common.collect.Iterators;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;

public final class TypeConversion {
    public static final String ARRAY_DELIMITER = ";";
    public static final String KEY_VALUE_DELIMITER = "=";

    private TypeConversion() {
    }

    public static <T> T stringToObject(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == String[].class) {
            return (T)StringUtils.splitPreserveAllTokens((String)value, (String)ARRAY_DELIMITER);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(NumberUtils.toInt((String)value, (int)0));
        }
        if (type == Long.class) {
            return (T)Long.valueOf(NumberUtils.toLong((String)value, (long)0L));
        }
        if (type == Double.class) {
            return (T)Double.valueOf(NumberUtils.toDouble((String)value, (double)0.0));
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(BooleanUtils.toBoolean((String)value));
        }
        if (type == Map.class) {
            String[] rows = StringUtils.splitPreserveAllTokens((String)value, (String)ARRAY_DELIMITER);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < rows.length; ++i) {
                String[] keyValue = StringUtils.splitPreserveAllTokens((String)rows[i], (String)KEY_VALUE_DELIMITER);
                if (keyValue.length != 2 || !StringUtils.isNotEmpty((CharSequence)keyValue[0])) continue;
                map.put(keyValue[0], StringUtils.isEmpty((CharSequence)keyValue[1]) ? null : keyValue[1]);
            }
            return (T)map;
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getName());
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof String[]) {
            return StringUtils.join((Object[])((String[])value), (String)ARRAY_DELIMITER);
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value);
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            StringBuilder stringValue = new StringBuilder();
            Map.Entry[] entries = (Map.Entry[])Iterators.toArray(map.entrySet().iterator(), Map.Entry.class);
            for (int i = 0; i < entries.length; ++i) {
                Map.Entry entry = entries[i];
                String entryKey = ObjectUtils.toString(entry.getKey());
                String entryValue = ObjectUtils.toString(entry.getValue());
                stringValue.append(entryKey).append(KEY_VALUE_DELIMITER).append(entryValue);
                if (i >= entries.length - 1) continue;
                stringValue.append(ARRAY_DELIMITER);
            }
            return stringValue.toString();
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
    }

    public static <T> T osgiPropertyToObject(Object value, Class<T> type, T defaultValue) {
        if (type == String.class) {
            return (T)PropertiesUtil.toString((Object)value, (String)((String)defaultValue));
        }
        if (type == String[].class) {
            return (T)PropertiesUtil.toStringArray((Object)value, (String[])((String[])defaultValue));
        }
        if (type == Integer.class) {
            Integer defaultIntValue = (Integer)defaultValue;
            if (defaultIntValue == null) {
                defaultIntValue = 0;
            }
            return (T)Integer.valueOf(PropertiesUtil.toInteger((Object)value, (int)defaultIntValue));
        }
        if (type == Long.class) {
            Long defaultLongValue = (Long)defaultValue;
            if (defaultLongValue == null) {
                defaultLongValue = 0L;
            }
            return (T)Long.valueOf(PropertiesUtil.toLong((Object)value, (long)defaultLongValue));
        }
        if (type == Double.class) {
            Double defaultDoubleValue = (Double)defaultValue;
            if (defaultDoubleValue == null) {
                defaultDoubleValue = 0.0;
            }
            return (T)Double.valueOf(PropertiesUtil.toDouble((Object)value, (double)defaultDoubleValue));
        }
        if (type == Boolean.class) {
            Boolean defaultBooleanValue = (Boolean)defaultValue;
            if (defaultBooleanValue == null) {
                defaultBooleanValue = false;
            }
            return (T)Boolean.valueOf(PropertiesUtil.toBoolean((Object)value, (boolean)defaultBooleanValue));
        }
        if (type == Map.class) {
            String[] defaultMapValue;
            Map defaultMap = (Map)defaultValue;
            if (defaultMap == null) {
                defaultMapValue = new String[]{};
            } else {
                defaultMapValue = new String[defaultMap.size()];
                Map.Entry[] entries = (Map.Entry[])Iterators.toArray(defaultMap.entrySet().iterator(), Map.Entry.class);
                for (int i = 0; i < entries.length; ++i) {
                    defaultMapValue[i] = ObjectUtils.toString(entries[i].getKey()) + KEY_VALUE_DELIMITER + ObjectUtils.toString(entries[i].getValue());
                }
            }
            return (T)PropertiesUtil.toMap((Object)value, (String[])defaultMapValue);
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getName());
    }
}

