/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.persistence;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import io.wcm.config.spi.ParameterPersistenceProvider;
import java.util.Dictionary;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=true, label="wcm.io Configuration Persistence Provider: /tools/config Pages", description="Allows to read and store configurations in /tools/config pages.")
@Service(value={ParameterPersistenceProvider.class})
public final class ToolsConfigPagePersistenceProvider
implements ParameterPersistenceProvider {
    static final String CONFIG_PAGE_NAME = "config";
    static final String CONFIG_RESOURCE_NAME = "config";
    static final String TOOLS_PAGE_NAME = "tools";
    static final String RELATIVE_CONFIG_PATH = "/tools/config";
    @Property(label="Enabled", boolValue={false}, description="Enable parameter persistence provider")
    static final String PROPERTY_ENABLED = "enabled";
    static final boolean DEFAULT_ENABLED = false;
    @Property(label="Service Ranking", intValue={1000}, description="Priority of parameter persistence providers (lower = higher priority)", propertyPrivate=false)
    static final String PROPERTY_RANKING = "service.ranking";
    static final int DEFAULT_RANKING = 1000;
    @Property(label="Config Template", value={""}, description="Template that is used for a configuration page.")
    static final String PROPERTY_CONFIG_PAGE_TEMPLATE = "configPageTemplate";
    static final String DEFAULT_CONFIG_PAGE_TEMPLATE = "";
    @Property(label="Tools Template", value={""}, description="Template that is used for tools page.")
    static final String PROPERTY_TOOLS_PAGE_TEMPLATE = "toolsPageTemplate";
    static final String DEFAULT_TOOLS_PAGE_TEMPLATE = "";
    private boolean enabled;
    private String configPageTemplate;
    private String toolsPageTemplate;

    public Map<String, Object> get(ResourceResolver resolver, String configurationId) {
        if (!this.enabled) {
            return null;
        }
        Page configPage = this.getConfigPage(resolver, configurationId);
        if (configPage != null) {
            return this.getConfigMap(configPage);
        }
        return null;
    }

    public boolean store(ResourceResolver resolver, String configurationId, Map<String, Object> values) throws PersistenceException {
        if (!this.enabled) {
            return false;
        }
        Page configPage = this.getOrCreateConfigPage(resolver, configurationId);
        this.storeValues(resolver, configPage, values);
        return true;
    }

    private String getConfigPagePath(String configurationId) {
        return configurationId + RELATIVE_CONFIG_PATH;
    }

    private Page getConfigPage(ResourceResolver resolver, String configurationId) {
        String path = this.getConfigPagePath(configurationId);
        Resource resource = resolver.getResource(path);
        if (resource != null) {
            return (Page)resource.adaptTo(Page.class);
        }
        return null;
    }

    private Map<String, Object> getConfigMap(Page page) {
        Resource configResource = page.getContentResource("config");
        if (configResource != null) {
            return configResource.getValueMap();
        }
        return ValueMap.EMPTY;
    }

    private Page getOrCreateConfigPage(ResourceResolver resolver, String configurationId) throws PersistenceException {
        Page configPage = this.getConfigPage(resolver, configurationId);
        if (configPage == null) {
            PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
            String configPagePath = this.getConfigPagePath(configurationId);
            String toolsPagePath = ResourceUtil.getParent((String)configPagePath);
            Resource toolsPageResource = resolver.getResource(toolsPagePath);
            if (toolsPageResource == null) {
                try {
                    pageManager.create(configurationId, TOOLS_PAGE_NAME, this.toolsPageTemplate, TOOLS_PAGE_NAME, true);
                }
                catch (WCMException ex) {
                    throw new PersistenceException("Creating page at " + toolsPagePath + " failed.", (Throwable)ex);
                }
            }
            try {
                configPage = pageManager.create(toolsPagePath, "config", this.configPageTemplate, "config", true);
            }
            catch (WCMException ex) {
                throw new PersistenceException("Creating page at " + configPagePath + " failed.", (Throwable)ex);
            }
        }
        return configPage;
    }

    private void storeValues(ResourceResolver resolver, Page configPage, Map<String, Object> values) throws PersistenceException {
        try {
            Resource configResource = configPage.getContentResource("config");
            if (configResource != null) {
                resolver.delete(configResource);
            }
            configResource = resolver.create(configPage.getContentResource(), "config", values);
            resolver.commit();
        }
        catch (PersistenceException ex) {
            throw new PersistenceException("Storing configuration values to " + configPage.getPath() + " failed.", (Throwable)ex);
        }
    }

    @Activate
    void activate(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        this.enabled = PropertiesUtil.toBoolean(config.get(PROPERTY_ENABLED), (boolean)false);
        this.configPageTemplate = PropertiesUtil.toString(config.get(PROPERTY_CONFIG_PAGE_TEMPLATE), (String)"");
        this.toolsPageTemplate = PropertiesUtil.toString(config.get(PROPERTY_TOOLS_PAGE_TEMPLATE), (String)"");
    }
}

