/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.override;

import com.google.common.collect.ImmutableMap;
import io.wcm.config.spi.ParameterOverrideProvider;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true, metatype=true, label="wcm.io Configuration Property Override Provider: System Properties", description="Allows to define configuration property default values or overrides from system environment properties.")
@Service(value={ParameterOverrideProvider.class})
public final class SystemPropertyOverrideProvider
implements ParameterOverrideProvider {
    public static final String SYSTEM_PROPERTY_PREFIX = "config.override.";
    @Property(label="Enabled", boolValue={false}, description="Enable parameter override provider")
    static final String PROPERTY_ENABLED = "enabled";
    static final boolean DEFAULT_ENABLED = false;
    @Property(label="Service Ranking", intValue={2000}, description="Priority of parameter override providers (lower = higher priority)", propertyPrivate=false)
    static final String PROPERTY_RANKING = "service.ranking";
    static final int DEFAULT_RANKING = 2000;
    private Map<String, String> overrideMap;

    public Map<String, String> getOverrideMap() {
        return this.overrideMap;
    }

    @Activate
    void activate(ComponentContext ctx) {
        Dictionary config = ctx.getProperties();
        boolean enabled = PropertiesUtil.toBoolean(config.get(PROPERTY_ENABLED), (boolean)false);
        HashMap<String, String> map = new HashMap<String, String>();
        if (enabled) {
            Properties properties = System.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key;
                Object keyObject = keys.nextElement();
                if (!(keyObject instanceof String) || !StringUtils.startsWith((CharSequence)(key = (String)keyObject), (CharSequence)SYSTEM_PROPERTY_PREFIX)) continue;
                map.put(StringUtils.substringAfter((String)key, (String)SYSTEM_PROPERTY_PREFIX), System.getProperty(key));
            }
        }
        this.overrideMap = ImmutableMap.copyOf(map);
    }
}

