/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.management.impl;

import com.google.common.collect.Iterators;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

final class PersistenceTypeConversion {
    private PersistenceTypeConversion() {
    }

    public static boolean isTypeConversionRequired(Class<?> parameterType) {
        return Map.class.isAssignableFrom(parameterType);
    }

    public static Object toPersistenceType(Object value, Class<?> parameterType) {
        if (!PersistenceTypeConversion.isTypeConversionRequired(parameterType)) {
            return value;
        }
        if (Map.class.isAssignableFrom(parameterType) && value instanceof Map) {
            Map map = (Map)value;
            Map.Entry[] entries = (Map.Entry[])Iterators.toArray(map.entrySet().iterator(), Map.Entry.class);
            String[] stringArray = new String[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                Map.Entry entry = entries[i];
                String entryKey = ObjectUtils.toString(entry.getKey());
                String entryValue = ObjectUtils.toString(entry.getValue());
                stringArray[i] = entryKey + "=" + entryValue;
            }
            return stringArray;
        }
        throw new IllegalArgumentException("Type conversion not supported: " + parameterType.getName());
    }

    public static Object fromPersistenceType(Object value, Class<?> parameterType) {
        if (!PersistenceTypeConversion.isTypeConversionRequired(parameterType)) {
            return value;
        }
        if (Map.class.isAssignableFrom(parameterType) && value instanceof String[]) {
            String[] rows = (String[])value;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < rows.length; ++i) {
                String[] keyValue = StringUtils.splitPreserveAllTokens((String)rows[i], (String)"=");
                if (keyValue.length != 2 || !StringUtils.isNotEmpty((CharSequence)keyValue[0])) continue;
                map.put(keyValue[0], StringUtils.isEmpty((CharSequence)keyValue[1]) ? null : keyValue[1]);
            }
            return map;
        }
        throw new IllegalArgumentException("Type conversion not supported: " + parameterType.getName());
    }
}

