/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.management.impl;

import io.wcm.config.api.Application;
import io.wcm.config.core.management.ApplicationFinder;
import io.wcm.config.spi.ApplicationProvider;
import io.wcm.sling.commons.osgi.RankedServices;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

@Component(immediate=true, metatype=false)
@Service(value={ApplicationFinder.class})
public final class ApplicationFinderImpl
implements ApplicationFinder {
    @Reference(name="applicationProvider", referenceInterface=ApplicationProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ApplicationProvider> applicationProviders = new RankedServices();

    @Override
    public Application find(Resource resource) {
        for (ApplicationProvider provider : this.applicationProviders) {
            if (!provider.matches(resource)) continue;
            return new Application(provider.getApplicationId(), provider.getLabel());
        }
        return null;
    }

    @Override
    public Set<Application> getAll() {
        TreeSet<Application> allApps = new TreeSet<Application>();
        for (ApplicationProvider provider : this.applicationProviders) {
            allApps.add(new Application(provider.getApplicationId(), provider.getLabel()));
        }
        return allApps;
    }

    void bindApplicationProvider(ApplicationProvider service, Map<String, Object> props) {
        this.applicationProviders.bind((Object)service, props);
    }

    void unbindApplicationProvider(ApplicationProvider service, Map<String, Object> props) {
        this.applicationProviders.unbind((Object)service, props);
    }
}

