/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.impl;

import io.wcm.config.api.Configuration;
import io.wcm.config.api.Parameter;
import io.wcm.sling.commons.resource.ImmutableValueMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;

public final class ConfigurationImpl
implements Configuration {
    private final String configurationId;
    private final ValueMap properties;

    public ConfigurationImpl(String configurationId, Map<String, Object> properties) {
        this.configurationId = configurationId;
        this.properties = ImmutableValueMap.copyOf(properties);
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public <T> T get(Parameter<T> parameter) {
        return (T)this.properties.get(parameter.getName(), parameter.getType());
    }

    public <T> T get(Parameter<T> parameter, T defaultValue) {
        return (T)this.properties.get(parameter.getName(), defaultValue);
    }

    public <T> T get(String name, Class<T> type) {
        return (T)this.properties.get(name, type);
    }

    public <T> T get(String name, T defaultValue) {
        return (T)this.properties.get(name, defaultValue);
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    public Object put(String key, Object value) {
        return this.properties.put((Object)key, value);
    }

    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this.properties.putAll(m);
    }

    public void clear() {
        this.properties.clear();
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public Collection<Object> values() {
        return this.properties.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }
}

