/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.config.core.impl;

import io.wcm.config.api.Application;
import io.wcm.config.api.Configuration;
import io.wcm.config.core.impl.AdaptableUtil;
import io.wcm.config.core.management.ApplicationFinder;
import io.wcm.config.core.management.ConfigurationFinder;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;

@Component(immediate=true, metatype=false)
@Service(value={AdapterFactory.class})
@Properties(value={@Property(name="adaptables", value={"org.apache.sling.api.SlingHttpServletRequest", "org.apache.sling.api.resource.Resource"}), @Property(name="adapters", value={"io.wcm.config.api.Configuration"}), @Property(name="adapter.condition", value={"If a configuration can be found for the current/given resource or it's parents."})})
public final class ConfigurationAdapterFactory
implements AdapterFactory {
    @Reference
    private ConfigurationFinder configurationFinder;
    @Reference
    private ApplicationFinder applicationFinder;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Resource resource;
        if (type == Configuration.class) {
            Resource resource2 = AdaptableUtil.getResource(adaptable);
            if (resource2 != null) {
                return (AdapterType)this.configurationFinder.find(resource2);
            }
        } else if (type == Application.class && (resource = AdaptableUtil.getResource(adaptable)) != null) {
            return (AdapterType)this.applicationFinder.find(resource);
        }
        return null;
    }

    protected void bindConfigurationFinder(ConfigurationFinder configurationFinder) {
        this.configurationFinder = configurationFinder;
    }

    protected void unbindConfigurationFinder(ConfigurationFinder configurationFinder) {
        if (this.configurationFinder == configurationFinder) {
            this.configurationFinder = null;
        }
    }

    protected void bindApplicationFinder(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    protected void unbindApplicationFinder(ApplicationFinder applicationFinder) {
        if (this.applicationFinder == applicationFinder) {
            this.applicationFinder = null;
        }
    }
}

