/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.references.impl;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={EventHandler.class}, property={"event.topics=org/osgi/framework/BundleEvent/STARTED", "event.topics=org/osgi/framework/BundleEvent/REGISTERED"})
@Designate(ocd=Config.class)
public class CoreCompReferenceProviderDisabler
implements EventHandler {
    static final String CORECOMP_REFERENCE_PROVIDER = "com.adobe.cq.wcm.core.components.internal.services.CaConfigReferenceProvider";
    @Reference
    private ServiceComponentRuntime scr;
    private BundleContext bundleContext;
    private boolean enabled;

    @Activate
    void activate(BundleContext context, Config config) {
        this.bundleContext = context;
        this.enabled = config.enabled();
        this.disableComponent();
    }

    public void handleEvent(Event event) {
        this.disableComponent();
    }

    private void disableComponent() {
        if (!this.enabled) {
            return;
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ComponentDescriptionDTO dto = this.scr.getComponentDescriptionDTO(bundle, CORECOMP_REFERENCE_PROVIDER);
            if (dto == null || !this.scr.isComponentEnabled(dto)) continue;
            this.scr.disableComponent(dto);
        }
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Reference Provider Core Component Disabler", description="Disables the context-aware configuration reference provider from Adobe Core Components, which does not reliably detect the last modification date of configuration stored in AEM pages.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable to automatic disable the reference provider from Core Components.")
        public boolean enabled() default true;
    }
}

