/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.extensions.persistence.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.caconfig.extensions.persistence.impl.PersistenceUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceStrategy2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ConfigurationPersistenceStrategy2.class})
@Designate(ocd=Config.class)
public class PagePersistenceStrategy
implements ConfigurationPersistenceStrategy2 {
    private static final String DEFAULT_CONFIG_NODE_TYPE = "nt:unstructured";
    @Reference
    private ConfigurationManagementSettings configurationManagementSettings;
    @Reference
    private PageManagerFactory pageManagerFactory;
    private boolean enabled;
    private String resourceType;
    private boolean collectionMarkAllItemsUpdated;
    private Set<String> configNameDenyList;

    @Activate
    void activate(Config config) {
        this.enabled = config.enabled();
        this.resourceType = config.resourceType();
        this.collectionMarkAllItemsUpdated = config.collectionMarkAllItemsUpdated();
        this.configNameDenyList = Set.copyOf(Arrays.asList(config.configNameDenyList()));
    }

    public Resource getResource(@NotNull Resource resource) {
        if (!this.enabled) {
            return null;
        }
        if (PersistenceUtils.containsJcrContent(resource.getPath())) {
            return resource;
        }
        return resource.getChild("jcr:content");
    }

    public Resource getCollectionParentResource(@NotNull Resource resource) {
        if (!this.enabled) {
            return null;
        }
        return resource;
    }

    public Resource getCollectionItemResource(@NotNull Resource resource) {
        return this.getResource(resource);
    }

    public String getResourcePath(@NotNull String resourcePath) {
        if (!this.enabled) {
            return null;
        }
        if (PersistenceUtils.containsJcrContent(resourcePath)) {
            return resourcePath;
        }
        return resourcePath + "/jcr:content";
    }

    public String getCollectionParentResourcePath(@NotNull String resourcePath) {
        if (!this.enabled) {
            return null;
        }
        return resourcePath;
    }

    public String getCollectionItemResourcePath(@NotNull String resourcePath) {
        return this.getResourcePath(resourcePath);
    }

    public String getConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        if (!this.enabled && this.isConfigNameDenied(configName)) {
            return null;
        }
        if (PersistenceUtils.containsJcrContent(configName)) {
            return configName;
        }
        return configName + "/jcr:content";
    }

    public String getCollectionParentConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        if (!this.enabled && this.isConfigNameDenied(configName)) {
            return null;
        }
        return configName;
    }

    public String getCollectionItemConfigName(@NotNull String configName, @Nullable String relatedConfigPath) {
        return this.getConfigName(configName, relatedConfigPath);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean persistConfiguration(@NotNull ResourceResolver resolver, @NotNull String configResourcePath, @NotNull ConfigurationPersistData data) {
        if (!this.enabled || this.isConfigResourcePathDenied(configResourcePath)) {
            return false;
        }
        String path = this.getResourcePath(configResourcePath);
        PersistenceUtils.ensureContainingPage(resolver, path, this.resourceType, this.configurationManagementSettings);
        PersistenceUtils.getOrCreateResource(resolver, path, DEFAULT_CONFIG_NODE_TYPE, data.getProperties(), this.configurationManagementSettings);
        PageManager pageManager = this.pageManagerFactory.getPageManager(resolver);
        PersistenceUtils.updatePageLastMod(resolver, pageManager, path);
        PersistenceUtils.commit(resolver, configResourcePath);
        return true;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean persistConfigurationCollection(@NotNull ResourceResolver resolver, @NotNull String configResourceCollectionParentPath, @NotNull ConfigurationCollectionPersistData data) {
        if (!this.enabled || this.isConfigResourcePathDenied(configResourceCollectionParentPath)) {
            return false;
        }
        PageManager pageManager = this.pageManagerFactory.getPageManager(resolver);
        String parentPath = this.getCollectionParentResourcePath(configResourceCollectionParentPath);
        PersistenceUtils.ensurePageIfNotContainingPage(resolver, parentPath, this.resourceType, this.configurationManagementSettings);
        Resource configResourceParent = PersistenceUtils.getOrCreateResource(resolver, parentPath, DEFAULT_CONFIG_NODE_TYPE, (Map<String, Object>)ValueMap.EMPTY, this.configurationManagementSettings);
        PersistenceUtils.updatePageLastMod(resolver, pageManager, parentPath);
        PersistenceUtils.deleteChildrenNotInCollection(configResourceParent, data);
        for (ConfigurationPersistData item : data.getItems()) {
            String path = this.getCollectionItemResourcePath(parentPath + "/" + item.getCollectionItemName());
            if (!this.collectionMarkAllItemsUpdated && !PersistenceUtils.isItemModifiedOrNewlyAdded(resolver, path, item, this.configurationManagementSettings)) continue;
            PersistenceUtils.ensureContainingPage(resolver, path, this.resourceType, this.configurationManagementSettings);
            PersistenceUtils.getOrCreateResource(resolver, path, DEFAULT_CONFIG_NODE_TYPE, item.getProperties(), this.configurationManagementSettings);
            PersistenceUtils.updatePageLastMod(resolver, pageManager, path);
        }
        if (data.getProperties() != null) {
            Page parentPage = (Page)configResourceParent.adaptTo(Page.class);
            if (parentPage != null) {
                PersistenceUtils.replaceProperties(parentPage.getContentResource(), data.getProperties(), this.configurationManagementSettings);
            } else {
                PersistenceUtils.replaceProperties(configResourceParent, data.getProperties(), this.configurationManagementSettings);
            }
        }
        PersistenceUtils.commit(resolver, configResourceCollectionParentPath);
        return true;
    }

    public boolean deleteConfiguration(@NotNull ResourceResolver resolver, @NotNull String configResourcePath) {
        if (!this.enabled || this.isConfigResourcePathDenied(configResourcePath)) {
            return false;
        }
        Resource configResource = resolver.getResource(configResourcePath);
        if (configResource != null) {
            PersistenceUtils.deletePageOrResource(configResource);
        }
        PageManager pageManager = this.pageManagerFactory.getPageManager(resolver);
        PersistenceUtils.updatePageLastMod(resolver, pageManager, configResourcePath);
        PersistenceUtils.commit(resolver, configResourcePath);
        return true;
    }

    private boolean isConfigNameDenied(@NotNull String configName) {
        return this.configNameDenyList.contains(configName);
    }

    private boolean isConfigResourcePathDenied(@NotNull String configResourcePath) {
        String resourceName = ResourceUtil.getName((String)configResourcePath);
        return this.isConfigNameDenied(resourceName);
    }

    @ObjectClassDefinition(name="wcm.io Context-Aware Configuration Persistence Strategy: AEM Page", description="Stores Context-Aware Configuration in AEM pages instead of simple resources.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable this persistence strategy.")
        public boolean enabled() default false;

        @AttributeDefinition(name="Resource type", description="Resource type for configuration pages.")
        public String resourceType();

        @AttributeDefinition(name="Collection: Mark all items updated", description="When modifying a single collection item, mark all items in the collection as updated. This is a workaround for a problem publishing collections in AEMaaCS.")
        public boolean collectionMarkAllItemsUpdated() default true;

        @AttributeDefinition(name="Service Ranking", description="Priority of persistence strategy (higher = higher priority).")
        public int service_ranking() default 1500;

        @AttributeDefinition(name="Config Name Deny List", description="List of context-aware configuration names this persistence implementation should ignore.")
        public String[] configNameDenyList() default {"com.adobe.aem.wcm.site.manager.config.SiteConfig"};
    }
}

