/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Service type for Redis data source.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.RedisDataSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.RedisDataSource.class)
public class RedisDataSource {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisDataSource that = (RedisDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisDataSource> __TYPE_ARG = new TypeArg<>(    obj -> new RedisDataSource((io.vertx.servicediscovery.types.RedisDataSource) obj),
    RedisDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.RedisDataSource delegate;
  
  public RedisDataSource(io.vertx.servicediscovery.types.RedisDataSource delegate) {
    this.delegate = delegate;
  }

  public RedisDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.RedisDataSource)delegate;
  }

  public io.vertx.servicediscovery.types.RedisDataSource getDelegate() {
    return delegate;
  }

  /**
   * Convenient method to create a record for a Redis data source.
   * @param name the service name
   * @param location the location of the service (e.g. url, port...)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, io.vertx.core.json.JsonObject location, io.vertx.core.json.JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.RedisDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Redis>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)event))));
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) {
    getRedisClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.redis.client.Redis> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getRedisClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Redis>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)event))));
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) {
    getRedisClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.redis.client.Redis> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getRedisClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Redis>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)event))));
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) {
    getRedisClient(discovery, filter, consumerConfiguration, ar -> { });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration The additional consumer configuration
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.redis.client.Redis> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle($handler -> {
      getRedisClient(discovery, filter, consumerConfiguration, $handler);
    });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   * @param resultHandler The result handler
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.json.JsonObject consumerConfiguration, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Redis>> resultHandler) { 
    io.vertx.servicediscovery.types.RedisDataSource.getRedisClient(discovery.getDelegate(), filter, consumerConfiguration, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.redis.client.Redis.newInstance((io.vertx.redis.client.Redis)event))));
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   */
  public static void getRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.json.JsonObject consumerConfiguration) {
    getRedisClient(discovery, filter, consumerConfiguration, ar -> { });
  }

  /**
   * Convenient method that looks for a Redis data source and provides the configured {@link io.vertx.reactivex.redis.client.Redis}.
   * The async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, cannot be <code>null</code>
   * @param consumerConfiguration The additional consumer configuration
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.redis.client.Redis> rxGetRedisClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle($handler -> {
      getRedisClient(discovery, filter, consumerConfiguration, $handler);
    });
  }

  /**
   * Unknown type.
   */
  public static final java.lang.String UNKNOWN = io.vertx.servicediscovery.types.RedisDataSource.UNKNOWN;
  public static final java.lang.String TYPE = io.vertx.servicediscovery.types.RedisDataSource.TYPE;
  public static RedisDataSource newInstance(io.vertx.servicediscovery.types.RedisDataSource arg) {
    return arg != null ? new RedisDataSource(arg) : null;
  }

}
