/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.oracleclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a pool of connection to interact with an Oracle database.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OraclePool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.oracleclient.OraclePool.class)
public class OraclePool extends io.vertx.reactivex.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OraclePool that = (OraclePool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OraclePool> __TYPE_ARG = new TypeArg<>(    obj -> new OraclePool((io.vertx.oracleclient.OraclePool) obj),
    OraclePool::getDelegate
  );

  private final io.vertx.oracleclient.OraclePool delegate;
  
  public OraclePool(io.vertx.oracleclient.OraclePool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OraclePool(Object delegate) {
    super((io.vertx.oracleclient.OraclePool)delegate);
    this.delegate = (io.vertx.oracleclient.OraclePool)delegate;
  }

  public io.vertx.oracleclient.OraclePool getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.oracleclient.OraclePool pool(io.vertx.oracleclient.OracleConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.oracleclient.OraclePool ret = io.vertx.reactivex.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.oracleclient.OraclePool#pool} with a specific  instance.
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.oracleclient.OraclePool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.oracleclient.OraclePool ret = io.vertx.reactivex.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.oracleclient.OraclePool#pool} but connection options are created from the provided <code>connectionUri</code>.
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.oracleclient.OraclePool pool(java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.oracleclient.OraclePool ret = io.vertx.reactivex.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.oracleclient.OraclePool#pool} with a specific  instance.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.oracleclient.OraclePool pool(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.oracleclient.OraclePool ret = io.vertx.reactivex.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  public io.vertx.reactivex.oracleclient.OraclePool connectHandler(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.reactivex.oracleclient.OraclePool connectionProvider(java.util.function.Function<io.vertx.reactivex.core.Context,io.vertx.core.Future<io.vertx.reactivex.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.vertx.core.Future<io.vertx.reactivex.sqlclient.SqlConnection> ret = provider.apply(io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)arg));
        return ret.map(val -> val.getDelegate());
      }
    });
    return this;
  }

  public io.vertx.reactivex.oracleclient.OraclePool connectionProvider(io.reactivex.functions.Function<io.vertx.reactivex.core.Context,io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection> ret;
        try {
          ret = provider.apply(io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  /**
   * Create a connection pool to the Oracle <code>databases</code>. The supplier is called
   * to provide the options when a new connection is created by the pool.
   * @param databases the databases supplier
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.oracleclient.OraclePool pool(java.util.function.Supplier<io.vertx.core.Future<io.vertx.oracleclient.OracleConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.oracleclient.OraclePool ret = io.vertx.reactivex.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(databases, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.oracleclient.OraclePool#pool} with a specific  instance.
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.oracleclient.OraclePool pool(io.vertx.reactivex.core.Vertx vertx, java.util.function.Supplier<io.vertx.core.Future<io.vertx.oracleclient.OracleConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.oracleclient.OraclePool ret = io.vertx.reactivex.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), databases, poolOptions));
    return ret;
  }

  public static OraclePool newInstance(io.vertx.oracleclient.OraclePool arg) {
    return arg != null ? new OraclePool(arg) : null;
  }

}
