/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A response from a gRPC server.
 *
 * You can set a {@link io.vertx.reactivex.grpc.client.GrpcClientResponse#messageHandler} to receive  and a {@link io.vertx.reactivex.grpc.client.GrpcClientResponse#endHandler} to be notified
 * of the end of the response.
 *
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.client.GrpcClientResponse original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.client.GrpcClientResponse.class)
public class GrpcClientResponse<Req,Resp> extends io.vertx.reactivex.grpc.common.GrpcReadStream<Resp> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcClientResponse that = (GrpcClientResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcClientResponse> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcClientResponse((io.vertx.grpc.client.GrpcClientResponse) obj),
    GrpcClientResponse::getDelegate
  );

  private final io.vertx.grpc.client.GrpcClientResponse<Req,Resp> delegate;
  public final TypeArg<Req> __typeArg_0;
  public final TypeArg<Resp> __typeArg_1;
  
  public GrpcClientResponse(io.vertx.grpc.client.GrpcClientResponse delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public GrpcClientResponse(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
    super((io.vertx.grpc.client.GrpcClientResponse)delegate);
    this.delegate = (io.vertx.grpc.client.GrpcClientResponse)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.grpc.client.GrpcClientResponse getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<Resp> observable;
  private io.reactivex.Flowable<Resp> flowable;

  public synchronized io.reactivex.Observable<Resp> toObservable() {
    if (observable == null) {
      Function<Resp, Resp> conv = (Function<Resp, Resp>) __typeArg_0.wrap;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<Resp> toFlowable() {
    if (flowable == null) {
      Function<Resp, Resp> conv = (Function<Resp, Resp>) __typeArg_0.wrap;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<Resp> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<Resp> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_1);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<Resp> dst, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<Resp> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<Resp> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      pipeTo(dst, $handler);
    });
  }

  /**
   * @return the last element of the stream
   */
  public io.vertx.core.Future<Resp> last() { 
    io.vertx.core.Future<Resp> ret = delegate.last().map(val -> (Resp)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * @return the last element of the stream
   */
  public io.reactivex.Single<Resp> rxLast() { 
    return AsyncResultSingle.toSingle($handler -> {
      last().onComplete($handler);
    });
  }

  /**
   * @return the gRPC status or <code>null</code> when the status has not yet been received
   */
  public io.vertx.grpc.common.GrpcStatus status() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.grpc.common.GrpcStatus ret = delegate.status();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the gRPC status message of <code>null</code> when the status has not yet been received or not transmitted
   */
  public java.lang.String statusMessage() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.lang.String ret = delegate.statusMessage();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the  to write metadata trailers
   */
  public io.vertx.reactivex.core.MultiMap trailers() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.trailers());
    return ret;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> messageHandler(io.vertx.core.Handler<io.vertx.reactivex.grpc.common.GrpcMessage> handler) { 
    delegate.messageHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.grpc.common.GrpcMessage.newInstance((io.vertx.grpc.common.GrpcMessage)event)));
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> errorHandler(io.vertx.core.Handler<io.vertx.grpc.common.GrpcError> handler) { 
    delegate.errorHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> handler(io.vertx.core.Handler<Resp> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> (Resp)__typeArg_1.wrap(event)));
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> endHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  public <R, A> io.vertx.core.Future<R> collecting(java.util.stream.Collector<Resp,A,R> collector) { 
    io.vertx.core.Future<R> ret = delegate.collecting(collector).map(val -> (R) val);
    return ret;
  }

  /**
   * @param collector 
   * @return the result of applying a collector on the stream
   */
  public <R, A> io.reactivex.Single<R> rxCollecting(java.util.stream.Collector<Resp,A,R> collector) { 
    return AsyncResultSingle.toSingle($handler -> {
      collecting(collector).onComplete($handler);
    });
  }

  private io.vertx.grpc.common.GrpcStatus cached_0;
  private java.lang.String cached_1;
  public static <Req,Resp> GrpcClientResponse<Req,Resp> newInstance(io.vertx.grpc.client.GrpcClientResponse arg) {
    return arg != null ? new GrpcClientResponse<Req,Resp>(arg) : null;
  }

  public static <Req,Resp> GrpcClientResponse<Req,Resp> newInstance(io.vertx.grpc.client.GrpcClientResponse arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
    return arg != null ? new GrpcClientResponse<Req,Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
  }

}
