/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A {@link io.vertx.reactivex.ext.web.Route} handler for GraphQL requests.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.GraphQLHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.GraphQLHandler.class)
public class GraphQLHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphQLHandler that = (GraphQLHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GraphQLHandler> __TYPE_ARG = new TypeArg<>(    obj -> new GraphQLHandler((io.vertx.ext.web.handler.graphql.GraphQLHandler) obj),
    GraphQLHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.GraphQLHandler delegate;
  
  public GraphQLHandler(io.vertx.ext.web.handler.graphql.GraphQLHandler delegate) {
    this.delegate = delegate;
  }

  public GraphQLHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.GraphQLHandler)delegate;
  }

  public io.vertx.ext.web.handler.graphql.GraphQLHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Customize the query context object.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler queryContext(java.util.function.Function<io.vertx.reactivex.ext.web.RoutingContext,java.lang.Object> factory) { 
    delegate.queryContext(new Function<io.vertx.ext.web.RoutingContext,java.lang.Object>() {
      public java.lang.Object apply(io.vertx.ext.web.RoutingContext arg) {
        java.lang.Object ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Set a callback to invoke before executing a GraphQL query.
   * @param config the callback to invoke
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler beforeExecute(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ExecutionInputBuilderWithContext<io.vertx.reactivex.ext.web.RoutingContext>> config) { 
    delegate.beforeExecute(new io.vertx.lang.rx.DelegatingHandler<>(config, event -> io.vertx.reactivex.ext.web.handler.graphql.ExecutionInputBuilderWithContext.newInstance((io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext)event, new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o0 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o0), o0 -> o0.getDelegate()))));
    return this;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler} that will use the provided <code>graphQL</code> object to execute queries.
   * <p>
   * The handler will be configured with default {@link io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions}.
   * @param graphQL 
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler create(graphql.GraphQL graphQL) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphQLHandler)io.vertx.ext.web.handler.graphql.GraphQLHandler.create(graphQL));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler} that will use the provided <code>graphQL</code> object to execute queries.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param graphQL 
   * @param options options for configuring the {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler create(graphql.GraphQL graphQL, io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions options) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphQLHandler)io.vertx.ext.web.handler.graphql.GraphQLHandler.create(graphQL, options));
    return ret;
  }

  /**
   * Retrieves the  from the .
   * @param graphQlContext the GraphQL context object
   * @return the 
   */
  public static io.vertx.reactivex.ext.web.RoutingContext getRoutingContext(graphql.GraphQLContext graphQlContext) { 
    io.vertx.reactivex.ext.web.RoutingContext ret = io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)io.vertx.ext.web.handler.graphql.GraphQLHandler.getRoutingContext(graphQlContext));
    return ret;
  }

  /**
   * Customize the .
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler dataLoaderRegistry(java.util.function.Function<io.vertx.reactivex.ext.web.RoutingContext,org.dataloader.DataLoaderRegistry> factory) { 
    delegate.dataLoaderRegistry(new Function<io.vertx.ext.web.RoutingContext,org.dataloader.DataLoaderRegistry>() {
      public org.dataloader.DataLoaderRegistry apply(io.vertx.ext.web.RoutingContext arg) {
        org.dataloader.DataLoaderRegistry ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Customize the  passed to the GraphQL execution engine.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler locale(java.util.function.Function<io.vertx.reactivex.ext.web.RoutingContext,java.util.Locale> factory) { 
    delegate.locale(new Function<io.vertx.ext.web.RoutingContext,java.util.Locale>() {
      public java.util.Locale apply(io.vertx.ext.web.RoutingContext arg) {
        java.util.Locale ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

  public static GraphQLHandler newInstance(io.vertx.ext.web.handler.graphql.GraphQLHandler arg) {
    return arg != null ? new GraphQLHandler(arg) : null;
  }

}
