/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A client-side HTTP request.
 * <p>
 * Instances are created by an {@link io.vertx.reactivex.ext.web.client.WebClient} instance, via one of the methods corresponding to the specific
 * HTTP methods such as {@link io.vertx.reactivex.ext.web.client.WebClient#get}, etc...
 * <p>
 * The request shall be configured prior sending, the request is immutable and when a mutator method
 * is called, a new request is returned allowing to expose the request in a public API and apply further customization.
 * <p>
 * After the request has been configured, the methods
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#send}</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#sendStream}</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#sendJson} ()}</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#sendForm}</li>
 * </ul>
 * can be called.
 * The <code>sendXXX</code> methods perform the actual request, they can be called multiple times to perform the same HTTP
 * request at different points in time.
 * <p>
 * The handler is called back with
 * <ul>
 *   <li>an {@link io.vertx.reactivex.ext.web.client.HttpResponse} instance when the HTTP response has been received</li>
 *   <li>a failure when the HTTP request failed (like a connection error) or when the HTTP response could
 *   not be obtained (like connection or unmarshalling errors)</li>
 * </ul>
 * <p>
 * Most of the time, this client will buffer the HTTP response fully unless a specific  is used
 * such as .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.HttpRequest original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpRequest that = (HttpRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpRequest> __TYPE_ARG = new TypeArg<>(    obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest) obj),
    HttpRequest::getDelegate
  );

  private final io.vertx.ext.web.client.HttpRequest<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public HttpRequest(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.web.client.HttpRequest)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.client.HttpRequest getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate>(o1 -> io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicate)o1), o1 -> o1.getDelegate());

  /**
   * Configure the request to use a new method <code>value</code>.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> method(io.vertx.core.http.HttpMethod value) { 
    delegate.method(value);
    return this;
  }

  /**
   * @return the request method
   */
  public io.vertx.core.http.HttpMethod method() { 
    io.vertx.core.http.HttpMethod ret = delegate.method();
    return ret;
  }

  /**
   * Configure the request to use a new port <code>value</code>.
   * <p> This overrides the port set by absolute URI requests
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> port(int value) { 
    delegate.port(value);
    return this;
  }

  /**
   * @return the request port or <code>0</code> when none is set for absolute URI templates
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * Configure the request to decode the response with the <code>responseCodec</code>.
   * @param responseCodec the response codec
   * @return a reference to this, so the API can be used fluently
   */
  public <U> io.vertx.reactivex.ext.web.client.HttpRequest<U> as(io.vertx.reactivex.ext.web.codec.BodyCodec<U> responseCodec) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<U> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
    return ret;
  }

  /**
   * @return the request body codec
   */
  public io.vertx.reactivex.ext.web.codec.BodyCodec<T> bodyCodec() { 
    io.vertx.reactivex.ext.web.codec.BodyCodec<T> ret = io.vertx.reactivex.ext.web.codec.BodyCodec.newInstance((io.vertx.ext.web.codec.BodyCodec)delegate.bodyCodec(), __typeArg_0);
    return ret;
  }

  /**
   * Configure the request to use a new host <code>value</code>.
   * <p> This overrides the host set by absolute URI requests
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> host(java.lang.String value) { 
    delegate.host(value);
    return this;
  }

  /**
   * @return the request host or <code>null</code> when none is set for absolute URI templates
   */
  public java.lang.String host() { 
    java.lang.String ret = delegate.host();
    return ret;
  }

  /**
   * Configure the request to use a virtual host <code>value</code>.
   * <p/>
   * Usually the header <i>host</i> (<i>:authority</i> pseudo header for HTTP/2) is set from the request host value
   * since this host value resolves to the server IP address.
   * <p/>
   * Sometimes you need to set a host header for an address that does not resolve to the server IP address.
   * The virtual host value overrides the value of the actual <i>host</i> header (<i>:authority</i> pseudo header
   * for HTTP/2).
   * <p/>
   * The virtual host is also be used for SNI.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> virtualHost(java.lang.String value) { 
    delegate.virtualHost(value);
    return this;
  }

  /**
   * @return the request virtual host if any or <code>null</code>
   */
  public java.lang.String virtualHost() { 
    java.lang.String ret = delegate.virtualHost();
    return ret;
  }

  /**
   * Configure the request to use a new request URI <code>value</code>.
   * <p> This overrides the port set by absolute URI requests
   * <p> When the uri has query parameters, they are set in the {@link io.vertx.reactivex.ext.web.client.HttpRequest#queryParams}, overwriting
   * any parameters previously set
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> uri(java.lang.String value) { 
    delegate.uri(value);
    return this;
  }

  /**
   * @return the request uri or <code>null</code> when none is set for absolute URI templates
   */
  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * Configure the request to add multiple HTTP headers .
   * @param headers The HTTP headers
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> putHeaders(io.vertx.reactivex.core.MultiMap headers) { 
    delegate.putHeaders(headers.getDelegate());
    return this;
  }

  /**
   * Configure the request to set a new HTTP header.
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> putHeader(java.lang.String name, java.lang.String value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @return The HTTP headers
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * Configure the request to perform basic access authentication.
   * <p>
   * In basic HTTP authentication, a request contains a header field of the form 'Authorization: Basic &#60;credentials&#62;',
   * where credentials is the base64 encoding of id and password joined by a colon.
   * </p>
   * In practical terms the arguments are converted to a  object.
   * @param id the id
   * @param password the password
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> basicAuthentication(java.lang.String id, java.lang.String password) { 
    delegate.basicAuthentication(id, password);
    return this;
  }

  /**
   * Configure the request to perform basic access authentication.
   * <p>
   * In basic HTTP authentication, a request contains a header field of the form 'Authorization: Basic &#60;credentials&#62;',
   * where credentials is the base64 encoding of id and password joined by a colon.
   * </p>
   * In practical terms the arguments are converted to a  object.
   * @param id the id
   * @param password the password
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> basicAuthentication(io.vertx.reactivex.core.buffer.Buffer id, io.vertx.reactivex.core.buffer.Buffer password) { 
    delegate.basicAuthentication(id.getDelegate(), password.getDelegate());
    return this;
  }

  /**
   * Configure the request to perform bearer token authentication.
   * <p>
   * In OAuth 2.0, a request contains a header field of the form 'Authorization: Bearer &#60;bearerToken&#62;',
   * where bearerToken is the bearer token issued by an authorization server to access protected resources.
   * </p>
   * In practical terms the arguments are converted to a  object.
   * @param bearerToken the bearer token
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> bearerTokenAuthentication(java.lang.String bearerToken) { 
    delegate.bearerTokenAuthentication(bearerToken);
    return this;
  }

  /**
   * Configure the request whether to use SSL.
   * <p> This overrides the SSL value set by absolute URI requests
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> ssl(java.lang.Boolean value) { 
    delegate.ssl(value);
    return this;
  }

  /**
   * @return whether the request uses SSL or <code>null</code> when none is set for absolute URI templates
   */
  public java.lang.Boolean ssl() { 
    java.lang.Boolean ret = delegate.ssl();
    return ret;
  }

  /**
   * Configures the amount of time in milliseconds after which if the request does not return any data within the timeout
   * period an {@link java.util.concurrent.TimeoutException} fails the request.
   * <p>
   * Setting zero or a negative <code>value</code> disables the timeout.
   * @param value The quantity of time in milliseconds.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> timeout(long value) { 
    delegate.timeout(value);
    return this;
  }

  /**
   * @return the current timeout in milliseconds
   */
  public long timeout() { 
    long ret = delegate.timeout();
    return ret;
  }

  /**
   * Add a query parameter to the request.
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> addQueryParam(java.lang.String paramName, java.lang.String paramValue) { 
    delegate.addQueryParam(paramName, paramValue);
    return this;
  }

  /**
   * Set a query parameter to the request.
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> setQueryParam(java.lang.String paramName, java.lang.String paramValue) { 
    delegate.setQueryParam(paramName, paramValue);
    return this;
  }

  /**
   * Set a request URI template string parameter to the request, expanded when the request URI is a .
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> setTemplateParam(java.lang.String paramName, java.lang.String paramValue) { 
    delegate.setTemplateParam(paramName, paramValue);
    return this;
  }

  /**
   * Set a request URI template list parameter to the request, expanded when the request URI is a .
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> setTemplateParam(java.lang.String paramName, java.util.List<java.lang.String> paramValue) { 
    delegate.setTemplateParam(paramName, paramValue);
    return this;
  }

  /**
   * Set a request URI template map parameter to the request, expanded when the request URI is a .
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> setTemplateParam(java.lang.String paramName, java.util.Map<java.lang.String,java.lang.String> paramValue) { 
    delegate.setTemplateParam(paramName, paramValue);
    return this;
  }

  /**
   * Set whether to follow request redirections
   * @param value true if redirections should be followed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> followRedirects(boolean value) { 
    delegate.followRedirects(value);
    return this;
  }

  /**
   * @return whether to follow request redirections
   */
  public boolean followRedirects() { 
    boolean ret = delegate.followRedirects();
    return ret;
  }

  /**
   * Configure the request to set a proxy for this request.
   *
   * Setting proxy here supersedes the proxy set on the client itself
   * @param proxyOptions The proxy options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> proxy(io.vertx.core.net.ProxyOptions proxyOptions) { 
    delegate.proxy(proxyOptions);
    return this;
  }

  /**
   * @return the proxy for this request
   */
  public io.vertx.core.net.ProxyOptions proxy() { 
    io.vertx.core.net.ProxyOptions ret = delegate.proxy();
    return ret;
  }

  /**
   * Add an expectation that the response is valid according to the provided <code>predicate</code>.
   * <p>
   * Multiple predicates can be added.
   * @param predicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> expect(java.util.function.Function<io.vertx.reactivex.ext.web.client.HttpResponse<java.lang.Void>,io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult> predicate) { 
    delegate.expect(new Function<io.vertx.ext.web.client.HttpResponse<java.lang.Void>,io.vertx.ext.web.client.predicate.ResponsePredicateResult>() {
      public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<java.lang.Void> arg) {
        io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult ret = predicate.apply(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)arg, TypeArg.unknown()));
        return ret.getDelegate();
      }
    });
    return this;
  }

  /**
   * Add an expectation that the response is valid according to the provided <code>predicate</code>.
   * <p>
   * Multiple predicates can be added.
   * @param predicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> expect(io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate predicate) { 
    delegate.expect(predicate.getDelegate());
    return this;
  }

  /**
   * @return a read-only list of the response predicate expectations
   */
  public java.util.List<io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate> expectations() { 
    java.util.List<io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate> ret = delegate.expectations().stream().map(elt -> io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate.newInstance((io.vertx.ext.web.client.predicate.ResponsePredicate)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Return the current query parameters.
   * @return the current query parameters
   */
  public io.vertx.reactivex.core.MultiMap queryParams() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.queryParams());
    return ret;
  }

  /**
   * Return the current request URI template parameters.
   * @return the current request URI template parameters
   */
  public io.vertx.reactivex.uritemplate.Variables templateParams() { 
    io.vertx.reactivex.uritemplate.Variables ret = io.vertx.reactivex.uritemplate.Variables.newInstance((io.vertx.uritemplate.Variables)delegate.templateParams());
    return ret;
  }

  /**
   * Copy this request
   * @return a copy of this request
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> copy() { 
    io.vertx.reactivex.ext.web.client.HttpRequest<T> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.copy(), __typeArg_0);
    return ret;
  }

  /**
   * Allow or disallow multipart mixed encoding when sending  having files sharing the same
   * file name.
   * <br/>
   * The default value is <code>true</code>.
   * <br/>
   * Set to <code>false</code> if you want to achieve the behavior for <a href="http://www.w3.org/TR/html5/forms.html#multipart-form-data">HTML5</a>.
   * @param allow <code>true</code> allows use of multipart mixed encoding
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> multipartMixed(boolean allow) { 
    delegate.multipartMixed(allow);
    return this;
  }

  /**
   * @return whether multipart mixed encoding is allowed
   */
  public boolean multipartMixed() { 
    boolean ret = delegate.multipartMixed();
    return ret;
  }

  /**
   * Trace operation name override.
   * @param traceOperation Name of operation to use in traces
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> traceOperation(java.lang.String traceOperation) { 
    delegate.traceOperation(traceOperation);
    return this;
  }

  /**
   * @return the trace operation name override
   */
  public java.lang.String traceOperation() { 
    java.lang.String ret = delegate.traceOperation();
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @param handler 
   */
  public void sendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendStream(body.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   */
  public void sendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body) {
    sendStream(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendStream(body, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @param handler 
   */
  public void sendStream(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendStream(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   */
  public void sendStream(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> body) {
    sendStream(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendStream(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendStream(body, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> buffer.
   * @param body the body
   * @param handler 
   */
  public void sendBuffer(io.vertx.reactivex.core.buffer.Buffer body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendBuffer(body.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> buffer.
   * @param body the body
   */
  public void sendBuffer(io.vertx.reactivex.core.buffer.Buffer body) {
    sendBuffer(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> buffer.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendBuffer(io.vertx.reactivex.core.buffer.Buffer body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendBuffer(body, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @param handler 
   */
  public void sendJsonObject(io.vertx.core.json.JsonObject body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendJsonObject(body, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   */
  public void sendJsonObject(io.vertx.core.json.JsonObject body) {
    sendJsonObject(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendJsonObject(io.vertx.core.json.JsonObject body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendJsonObject(body, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @param handler 
   */
  public void sendJson(java.lang.Object body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendJson(body, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   */
  public void sendJson(java.lang.Object body) {
    sendJson(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendJson(java.lang.Object body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendJson(body, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   * @param body the body
   * @param handler 
   */
  public void sendForm(io.vertx.reactivex.core.MultiMap body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendForm(body.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   * @param body the body
   */
  public void sendForm(io.vertx.reactivex.core.MultiMap body) {
    sendForm(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendForm(io.vertx.reactivex.core.MultiMap body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendForm(body, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   *
   * NOTE: the use of this method is strongly discouraged to use when the form is a <code>application/x-www-form-urlencoded</code>
   * encoded form since the charset to use must be UTF-8.
   * @param body the body
   * @param charset 
   * @param handler 
   */
  public void sendForm(io.vertx.reactivex.core.MultiMap body, java.lang.String charset, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendForm(body.getDelegate(), charset, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   *
   * NOTE: the use of this method is strongly discouraged to use when the form is a <code>application/x-www-form-urlencoded</code>
   * encoded form since the charset to use must be UTF-8.
   * @param body the body
   * @param charset 
   */
  public void sendForm(io.vertx.reactivex.core.MultiMap body, java.lang.String charset) {
    sendForm(body, charset, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   *
   * NOTE: the use of this method is strongly discouraged to use when the form is a <code>application/x-www-form-urlencoded</code>
   * encoded form since the charset to use must be UTF-8.
   * @param body the body
   * @param charset 
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendForm(io.vertx.reactivex.core.MultiMap body, java.lang.String charset) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendForm(body, charset, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
   * @param body the body
   * @param handler 
   */
  public void sendMultipartForm(io.vertx.reactivex.ext.web.multipart.MultipartForm body, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendMultipartForm(body.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
   * @param body the body
   */
  public void sendMultipartForm(io.vertx.reactivex.ext.web.multipart.MultipartForm body) {
    sendMultipartForm(body, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
   * @param body the body
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendMultipartForm(io.vertx.reactivex.ext.web.multipart.MultipartForm body) { 
    return AsyncResultSingle.toSingle($handler -> {
      sendMultipartForm(body, $handler);
    });
  }

  /**
   * Send a request, the <code>handler</code> will receive the response as an {@link io.vertx.reactivex.ext.web.client.HttpResponse}.
   * @param handler 
   */
  public void send(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.send(new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.ext.web.client.HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)event, __typeArg_0))));
  }

  /**
   * Send a request, the <code>handler</code> will receive the response as an {@link io.vertx.reactivex.ext.web.client.HttpResponse}.
   */
  public void send() {
    send(ar -> { });
  }

  /**
   * Send a request, the <code>handler</code> will receive the response as an {@link io.vertx.reactivex.ext.web.client.HttpResponse}.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSend() { 
    return AsyncResultSingle.toSingle($handler -> {
      send($handler);
    });
  }

  /**
   * Configure the request to set a new HTTP header with multiple values.
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> putHeader(java.lang.String name, java.lang.Iterable<java.lang.String> value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * Configure the request to perform HTTP Authentication.
   * <p>
   * Performs a generic authentication using the credentials provided by the user. For the sake of validation safety
   * it is recommended that  is called to ensure that the credentials
   * are applicable to the HTTP Challenged received on a previous request that returned a 401 response code.
   * @param credentials the credentials to use.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> authentication(io.vertx.ext.auth.authentication.Credentials credentials) { 
    delegate.authentication(credentials);
    return this;
  }

  private io.vertx.reactivex.core.MultiMap cached_0;
  public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
    return arg != null ? new HttpRequest<T>(arg) : null;
  }

  public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
  }

}
