/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.contract;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Main interface for Design Driven Router factory
 * Author: Francesco Guardiani @slinkydeveloper
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.contract.RouterFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.contract.RouterFactory.class)
public interface RouterFactory {

  io.vertx.ext.web.api.contract.RouterFactory getDelegate();

  /**
   * Mount to paths that have to follow a security schema a security handler
   * @param securitySchemaName 
   * @param handler 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory addSecurityHandler(java.lang.String securitySchemaName, io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> handler);

  /**
   * Set options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param options 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions options);

  /**
   * Get options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @return 
   */
  @Deprecated()
  public io.vertx.ext.web.api.contract.RouterFactoryOptions getOptions();

  /**
   * Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   * without assigned handlers<br/>
   * <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.Router getRouter();

  /**
   * @return 
   */
  @Deprecated()
  public io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> getValidationFailureHandler();

  /**
   * Set default validation failure handler. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param validationFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setValidationFailureHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> validationFailureHandler);

  /**
   * Set not implemented failure handler. It's called when you don't define an handler for a
   * specific operation. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param notImplementedFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setNotImplementedFailureHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> notImplementedFailureHandler);

  /**
   * Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files
   * @param bodyHandler 
   * @return self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setBodyHandler(io.vertx.reactivex.ext.web.handler.BodyHandler bodyHandler);

  /**
   * Add global handler to be applied prior to {@link io.vertx.reactivex.ext.web.Router} being generated. <br/>
   * Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use {@link io.vertx.reactivex.ext.web.api.contract.RouterFactory#setBodyHandler}
   * @param globalHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory addGlobalHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> globalHandler);

  /**
   * When set, this function is called while creating the payload of {@link io.vertx.ext.web.api.OperationRequest}
   * @param extraOperationContextPayloadMapper 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setExtraOperationContextPayloadMapper(java.util.function.Function<io.vertx.reactivex.ext.web.RoutingContext,io.vertx.core.json.JsonObject> extraOperationContextPayloadMapper);

  public static RouterFactory newInstance(io.vertx.ext.web.api.contract.RouterFactory arg) {
    return arg != null ? new RouterFactoryImpl(arg) : null;
  }

}

class RouterFactoryImpl implements RouterFactory {
  private final io.vertx.ext.web.api.contract.RouterFactory delegate;
  
  public RouterFactoryImpl(io.vertx.ext.web.api.contract.RouterFactory delegate) {
    this.delegate = delegate;
  }

  public RouterFactoryImpl(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.contract.RouterFactory)delegate;
  }

  public io.vertx.ext.web.api.contract.RouterFactory getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.RoutingContext> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o1 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());

  /**
   * Mount to paths that have to follow a security schema a security handler
   * @param securitySchemaName 
   * @param handler 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory addSecurityHandler(java.lang.String securitySchemaName, io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addSecurityHandler(securitySchemaName, new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Set options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param options 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * Get options of router factory. For more info {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @return 
   */
  @Deprecated()
  public io.vertx.ext.web.api.contract.RouterFactoryOptions getOptions() { 
    io.vertx.ext.web.api.contract.RouterFactoryOptions ret = delegate.getOptions();
    return ret;
  }

  /**
   * Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   * without assigned handlers<br/>
   * <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.Router getRouter() { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.getRouter());
    return ret;
  }

  /**
   * @return 
   */
  @Deprecated()
  public io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> getValidationFailureHandler() { 
    io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          delegate.getValidationFailureHandler().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Set default validation failure handler. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param validationFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setValidationFailureHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> validationFailureHandler) { 
    delegate.setValidationFailureHandler(new io.vertx.lang.rx.DelegatingHandler<>(validationFailureHandler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Set not implemented failure handler. It's called when you don't define an handler for a
   * specific operation. You can enable/disable this feature from
   * {@link io.vertx.ext.web.api.contract.RouterFactoryOptions}
   * @param notImplementedFailureHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setNotImplementedFailureHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> notImplementedFailureHandler) { 
    delegate.setNotImplementedFailureHandler(new io.vertx.lang.rx.DelegatingHandler<>(notImplementedFailureHandler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files
   * @param bodyHandler 
   * @return self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setBodyHandler(io.vertx.reactivex.ext.web.handler.BodyHandler bodyHandler) { 
    delegate.setBodyHandler(bodyHandler.getDelegate());
    return this;
  }

  /**
   * Add global handler to be applied prior to {@link io.vertx.reactivex.ext.web.Router} being generated. <br/>
   * Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use {@link io.vertx.reactivex.ext.web.api.contract.RouterFactory#setBodyHandler}
   * @param globalHandler 
   * @return this object
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory addGlobalHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> globalHandler) { 
    delegate.addGlobalHandler(new io.vertx.lang.rx.DelegatingHandler<>(globalHandler, event -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * When set, this function is called while creating the payload of {@link io.vertx.ext.web.api.OperationRequest}
   * @param extraOperationContextPayloadMapper 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.contract.RouterFactory setExtraOperationContextPayloadMapper(java.util.function.Function<io.vertx.reactivex.ext.web.RoutingContext,io.vertx.core.json.JsonObject> extraOperationContextPayloadMapper) { 
    delegate.setExtraOperationContextPayloadMapper(new Function<io.vertx.ext.web.RoutingContext,io.vertx.core.json.JsonObject>() {
      public io.vertx.core.json.JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
        io.vertx.core.json.JsonObject ret = extraOperationContextPayloadMapper.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

}
