/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An executor for executing blocking code in Vert.x .<p>
 *
 * It provides the same <code>executeBlocking</code> operation than {@link io.vertx.reactivex.core.Context} and
 * {@link io.vertx.reactivex.core.Vertx} but on a separate worker pool.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.WorkerExecutor original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WorkerExecutor that = (WorkerExecutor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WorkerExecutor> __TYPE_ARG = new TypeArg<>(    obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor) obj),
    WorkerExecutor::getDelegate
  );

  private final io.vertx.core.WorkerExecutor delegate;
  
  public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
    this.delegate = delegate;
  }

  public WorkerExecutor(Object delegate) {
    this.delegate = (io.vertx.core.WorkerExecutor)delegate;
  }

  public io.vertx.core.WorkerExecutor getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.reactivex.core.Promise#complete} or {@link io.vertx.reactivex.core.Promise#complete} method, or the {@link io.vertx.reactivex.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  public <T> void executeBlocking(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> blockingCodeHandler, boolean ordered, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new io.vertx.lang.rx.DelegatingHandler<>(blockingCodeHandler, event -> io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), ordered, resultHandler);
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.reactivex.core.Promise#complete} or {@link io.vertx.reactivex.core.Promise#complete} method, or the {@link io.vertx.reactivex.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   */
  public <T> void executeBlocking(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> blockingCodeHandler, boolean ordered) {
    executeBlocking(blockingCodeHandler, ordered, ar -> { });
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.reactivex.core.Promise#complete} or {@link io.vertx.reactivex.core.Promise#complete} method, or the {@link io.vertx.reactivex.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxExecuteBlocking(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      executeBlocking(blockingCodeHandler, ordered, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  public <T> void executeBlocking(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> blockingCodeHandler, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new io.vertx.lang.rx.DelegatingHandler<>(blockingCodeHandler, event -> io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), resultHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   */
  public <T> void executeBlocking(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> blockingCodeHandler) {
    executeBlocking(blockingCodeHandler, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxExecuteBlocking(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> blockingCodeHandler) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      executeBlocking(blockingCodeHandler, $handler);
    });
  }

  /**
   * Close the executor.
   * @param handler the completion handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the executor.
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Close the executor.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  public static WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
    return arg != null ? new WorkerExecutor(arg) : null;
  }

}
