/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AMQP Client entry point.
 * Use this interface to create an instance of {@link io.vertx.reactivex.amqp.AmqpClient} and connect to a broker and server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpClient.class)
public class AmqpClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpClient that = (AmqpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpClient((io.vertx.amqp.AmqpClient) obj),
    AmqpClient::getDelegate
  );

  private final io.vertx.amqp.AmqpClient delegate;
  
  public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
    this.delegate = delegate;
  }

  public AmqpClient(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpClient)delegate;
  }

  public io.vertx.amqp.AmqpClient getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.amqp.AmqpClient} using an internal Vert.x instance (with default configuration) and
   * the given AMQP client configuration. Note that the created Vert.x instance will be closed when the client is
   * closed.
   * @param options the AMQP client options, may be <code>null</code> falling back to the default configuration
   * @return the created instances.
   */
  public static io.vertx.reactivex.amqp.AmqpClient create(io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.reactivex.amqp.AmqpClient ret = io.vertx.reactivex.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.amqp.AmqpClient} with the given Vert.x instance and the given options.
   * @param vertx the vert.x instance, must not be <code>null</code>
   * @param options the AMQP options, may be @{code null} falling back to the default configuration
   * @return the AMQP client instance
   */
  public static io.vertx.reactivex.amqp.AmqpClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.reactivex.amqp.AmqpClient ret = io.vertx.reactivex.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @param connectionHandler handler that will process the result, giving either the connection or failure cause. Must not be <code>null</code>.
   * @return 
   */
  public io.vertx.reactivex.amqp.AmqpClient connect(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpConnection>> connectionHandler) { 
    delegate.connect(new io.vertx.lang.rx.DelegatingHandler<>(connectionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)event))));
    return this;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return 
   */
  public io.vertx.reactivex.amqp.AmqpClient connect() {
    return 
connect(ar -> { });
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpConnection> rxConnect() { 
    return AsyncResultSingle.toSingle($handler -> {
      connect($handler);
    });
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @param closeHandler the close handler notified when the operation completes. It can be <code>null</code>.
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> closeHandler) { 
    delegate.close(closeHandler);
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @param completionHandler the handler called with the receiver. The receiver has been opened.
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createReceiver(java.lang.String address, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, new io.vertx.lang.rx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)event))));
    return this;
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createReceiver(java.lang.String address) {
    return 
createReceiver(address, ar -> { });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the client.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      createReceiver(address, $handler);
    });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @param completionHandler The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpClient createReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, receiverOptions, new io.vertx.lang.rx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)event))));
    return this;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpClient createReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) {
    return 
createReceiver(address, receiverOptions, ar -> { });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      createReceiver(address, receiverOptions, $handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param completionHandler The handler called with the sender, once opened
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createSender(java.lang.String address, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, new io.vertx.lang.rx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)event))));
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createSender(java.lang.String address) {
    return 
createSender(address, ar -> { });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the client.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      createSender(address, $handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @param completionHandler The handler called with the sender, once opened
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, options, new io.vertx.lang.rx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)event))));
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) {
    return 
createSender(address, options, ar -> { });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the client.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      createSender(address, options, $handler);
    });
  }

  public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
    return arg != null ? new AmqpClient(arg) : null;
  }

}
