/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.junit5.ScopedObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtensionParameterProvider;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public final class VertxExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    public static final int DEFAULT_TIMEOUT_DURATION = 30;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final String VERTX_INSTANCE_KEY = "Vertx";
    private static final String TEST_CONTEXT_KEY = "VertxTestContext";
    private final HashMap<Class<?>, VertxExtensionParameterProvider<?>> parameterProviders = new HashMap();

    public VertxExtension() {
        for (VertxExtensionParameterProvider parameterProvider : ServiceLoader.load(VertxExtensionParameterProvider.class)) {
            this.parameterProviders.put(parameterProvider.type(), parameterProvider);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.parameterProviders.keySet().contains(this.parameterType(parameterContext));
    }

    private Class<?> parameterType(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Store parentStore;
        Class<?> type = this.parameterType(parameterContext);
        VertxExtensionParameterProvider<?> parameterProvider = this.parameterProviders.get(type);
        if (type.equals(VertxTestContext.class)) {
            return this.newTestContext(extensionContext);
        }
        if (extensionContext.getParent().isPresent() && (parentStore = this.store((ExtensionContext)extensionContext.getParent().get())).get((Object)parameterProvider.key()) != null) {
            return VertxExtension.unpack(parentStore.get((Object)parameterProvider.key()));
        }
        ExtensionContext.Store store = this.store(extensionContext);
        return VertxExtension.unpack(store.getOrComputeIfAbsent((Object)parameterProvider.key(), key -> new ScopedObject(parameterProvider.newInstance(extensionContext, parameterContext), parameterProvider.parameterClosingConsumer())));
    }

    private static Object unpack(Object object) {
        if (object instanceof Supplier) {
            return ((Supplier)object).get();
        }
        return object;
    }

    private VertxTestContext newTestContext(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.store(extensionContext);
        ContextList contexts = (ContextList)store.getOrComputeIfAbsent((Object)TEST_CONTEXT_KEY, key -> new ContextList());
        VertxTestContext newTestContext = new VertxTestContext();
        contexts.add(newTestContext);
        return newTestContext;
    }

    private ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    private void joinActiveTestContexts(ExtensionContext extensionContext) throws Exception {
        if (extensionContext.getExecutionException().isPresent()) {
            return;
        }
        ContextList currentContexts = (ContextList)this.store(extensionContext).remove((Object)TEST_CONTEXT_KEY, ContextList.class);
        if (currentContexts != null) {
            for (VertxTestContext context : currentContexts) {
                Timeout annotation;
                int timeoutDuration = 30;
                TimeUnit timeoutUnit = DEFAULT_TIMEOUT_UNIT;
                Optional testMethod = extensionContext.getTestMethod();
                if (testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestMethod().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                } else if (extensionContext.getRequiredTestClass().isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestClass().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                }
                if (context.awaitCompletion(timeoutDuration, timeoutUnit)) {
                    if (!context.failed()) continue;
                    Throwable throwable = context.causeOfFailure();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                String message = "The test execution timed out. Make sure your asynchronous code includes calls to either VertxTestContext#completeNow(), VertxTestContext#failNow() or Checkpoint#flag()";
                String unsatisfiedCheckpointsDiagnosis = context.unsatisfiedCheckpointCallSites().stream().map(element -> "-> checkpoint in file " + element.getFileName() + " line " + element.getLineNumber()).collect(Collectors.joining("\n"));
                message = message + "\n\nUnsatisfied checkpoints diagnostics:\n" + unsatisfiedCheckpointsDiagnosis;
                throw new TimeoutException(message);
            }
        }
        if (extensionContext.getParent().isPresent()) {
            this.joinActiveTestContexts((ExtensionContext)extensionContext.getParent().get());
        }
    }

    private static class ContextList
    extends ArrayList<VertxTestContext> {
        private ContextList() {
        }
    }
}

