/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.openapi3;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.BaseSyncValidator;
import io.vertx.json.schema.common.JsonSchemaType;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.common.ValidatorPriority;

public class TypeValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            String type = schema.getString("type");
            String format = schema.getString("format");
            if (type == null) {
                throw new SchemaException(schema, "Null type keyword");
            }
            return new TypeValidator(TypeValidatorFactory.parseType(type, format, schema));
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for type/format/nullable keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey("type");
    }

    private static JsonSchemaType parseType(String type, String format, JsonObject schema) {
        switch (type) {
            case "integer": {
                return JsonSchemaType.INTEGER;
            }
            case "number": {
                return format != null && (format.equals("double") || format.equals("float")) ? JsonSchemaType.NUMBER_DECIMAL : JsonSchemaType.NUMBER;
            }
            case "boolean": {
                return JsonSchemaType.BOOLEAN;
            }
            case "string": {
                return JsonSchemaType.STRING;
            }
            case "object": {
                return JsonSchemaType.OBJECT;
            }
            case "array": {
                return JsonSchemaType.ARRAY;
            }
        }
        throw new SchemaException(schema, "Unknown type: " + type);
    }

    static class TypeValidator
    extends BaseSyncValidator {
        final JsonSchemaType type;

        public TypeValidator(JsonSchemaType type) {
            this.type = type;
        }

        @Override
        public ValidatorPriority getPriority() {
            return ValidatorPriority.MAX_PRIORITY;
        }

        @Override
        public void validateSync(ValidatorContext context, Object in) throws ValidationException {
            if (in != null && !this.type.checkInstance(in)) {
                throw ValidationException.create("input don't match type " + this.type.name(), "type", in);
            }
        }
    }
}

